/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.servers.Server;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.PerformBeanValidationFeatures;

public abstract class JavaHelidonCommonCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
PerformBeanValidationFeatures {
    static final String HELIDON_MP = "mp";
    static final String HELIDON_SE = "se";
    static final String HELIDON_NIMA = "nima";
    static final String HELIDON_NIMA_ANNOTATIONS = "nima-annotations";
    static final String MICROPROFILE_ROOT_PACKAGE = "rootJavaEEPackage";
    static final String MICROPROFILE_ROOT_DEP_PREFIX = "x-helidon-rootJavaEEDepPrefix";
    static final String X_HAS_RETURN_TYPE = "x-helidon-hasReturnType";
    static final String X_RETURN_TYPE_EXAMPLE_VALUE = "x-helidon-exampleReturnTypeValue";
    static final String MICROPROFILE_ROOT_PACKAGE_DESC = "Root package name for Java EE";
    static final String MICROPROFILE_ROOT_PACKAGE_JAVAX = "javax";
    static final String MICROPROFILE_ROOT_PACKAGE_JAKARTA = "jakarta";
    private static final String VALIDATION_ARTIFACT_PREFIX_KEY = "x-helidon-validationArtifactPrefix";
    private static final String VALIDATION_ARTIFACT_PREFIX_JAVAX = "";
    private static final String VALIDATION_ARTIFACT_PREFIX_JAKARTA = "jakarta.";
    private static final Map<String, String> EXAMPLE_RETURN_VALUES = new HashMap<String, String>();
    static final String MICROPROFILE_ROOT_PACKAGE_DEFAULT = "Helidon 2.x and earlier: javax; Helidon 3.x and later: jakarta";
    static final String SERIALIZATION_LIBRARY_JACKSON = "jackson";
    static final String SERIALIZATION_LIBRARY_JSONB = "jsonb";
    public static final String HELIDON_VERSION = "helidonVersion";
    public static final String DEFAULT_HELIDON_VERSION = "3.0.1";
    static final String HELIDON_VERSION_DESC = "Helidon version for generated code";
    static final String FULL_PROJECT = "fullProject";
    static final String FULL_PROJECT_DESC = "If set to true, it will generate all files; if set to false, it will only generate API files. If unspecified, the behavior depends on whether a project exists or not: if it does not, same as true; if it does, same as false. Note that test files are never overwritten.";
    private String helidonVersion;
    private String rootJavaEEPackage;
    private String rootJavaEEDepPrefix;

    public JavaHelidonCommonCodegen() {
        EXAMPLE_RETURN_VALUES.put("set", "Set");
        EXAMPLE_RETURN_VALUES.put("array", "List");
        EXAMPLE_RETURN_VALUES.put("map", "Map");
        this.cliOptions.add(new CliOption(HELIDON_VERSION, HELIDON_VERSION_DESC).defaultValue(DEFAULT_HELIDON_VERSION));
        this.cliOptions.add(new CliOption(MICROPROFILE_ROOT_PACKAGE, MICROPROFILE_ROOT_PACKAGE_DESC).defaultValue(MICROPROFILE_ROOT_PACKAGE_DEFAULT));
        this.cliOptions.add(new CliOption(FULL_PROJECT, FULL_PROJECT_DESC).defaultValue(VALIDATION_ARTIFACT_PREFIX_JAVAX));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        String userHelidonVersion = VALIDATION_ARTIFACT_PREFIX_JAVAX;
        String userParentVersion = VALIDATION_ARTIFACT_PREFIX_JAVAX;
        if (this.additionalProperties.containsKey("parentVersion")) {
            userParentVersion = this.additionalProperties.get("parentVersion").toString();
        }
        if (this.additionalProperties.containsKey(HELIDON_VERSION)) {
            userHelidonVersion = this.additionalProperties.get(HELIDON_VERSION).toString();
        }
        if (!userHelidonVersion.isEmpty()) {
            if (!userParentVersion.isEmpty() && !userHelidonVersion.equals(userParentVersion)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Both %s and %s properties were set with different value.", "parentVersion", HELIDON_VERSION));
            }
            this.setHelidonVersion(userHelidonVersion);
        } else if (!userParentVersion.isEmpty()) {
            this.setHelidonVersion(userParentVersion);
        } else {
            this.setHelidonVersion(DEFAULT_HELIDON_VERSION);
        }
        this.additionalProperties.put(HELIDON_VERSION, this.helidonVersion);
        this.setEEPackageAndDependencies(this.helidonVersion);
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        op.vendorExtensions.put(X_HAS_RETURN_TYPE, op.returnType != null && !op.returnType.equals("void"));
        op.vendorExtensions.put(X_RETURN_TYPE_EXAMPLE_VALUE, this.chooseExampleReturnTypeValue(op));
        return op;
    }

    protected void removeUnusedOptions() {
        this.removeCliOptions("scmConnection", "scmDeveloperConnection", "scmUrl", "developerName", "developerOrganization", "developerOrganizationUrl", "developerEmail", "parentArtifactId", "parentVersion", "parentGroupId", "disableHtmlEscaping");
    }

    protected void processSupportingFiles(List<SupportingFile> modifiable, List<SupportingFile> unmodifiable) {
        Boolean fullProject;
        Boolean bl = fullProject = !this.additionalProperties.containsKey(FULL_PROJECT) ? null : Boolean.valueOf(Boolean.parseBoolean(this.additionalProperties.get(FULL_PROJECT).toString()));
        if (fullProject == null && !this.projectFilesExist()) {
            this.supportingFiles.addAll(modifiable);
        } else if (Boolean.TRUE.equals(fullProject)) {
            this.supportingFiles.addAll(modifiable);
        }
        this.supportingFiles.addAll(unmodifiable);
    }

    protected boolean projectFilesExist() {
        return Paths.get(this.getOutputTestFolder(), new String[0]).toFile().exists();
    }

    protected String rootJavaEEPackage() {
        return this.rootJavaEEPackage;
    }

    private void setHelidonVersion(String version) {
        this.helidonVersion = version;
        this.setParentVersion(version);
    }

    private void setEEPackageAndDependencies(String version) {
        this.rootJavaEEPackage = this.checkAndSelectRootEEPackage(version);
        this.additionalProperties.put(MICROPROFILE_ROOT_PACKAGE, this.rootJavaEEPackage);
        this.rootJavaEEDepPrefix = this.checkAndSelectRootEEDepPrefix(version);
        this.additionalProperties.put(MICROPROFILE_ROOT_DEP_PREFIX, this.rootJavaEEDepPrefix);
        this.additionalProperties.put(VALIDATION_ARTIFACT_PREFIX_KEY, this.rootJavaEEDepPrefix.equals(MICROPROFILE_ROOT_PACKAGE_JAVAX) ? VALIDATION_ARTIFACT_PREFIX_JAVAX : VALIDATION_ARTIFACT_PREFIX_JAKARTA);
    }

    private String checkAndSelectRootEEPackage(String version) {
        String packagePrefixImpliedByVersion;
        String string = packagePrefixImpliedByVersion = this.usesJakartaPackages(version) ? MICROPROFILE_ROOT_PACKAGE_JAKARTA : MICROPROFILE_ROOT_PACKAGE_JAVAX;
        if (this.additionalProperties.containsKey(MICROPROFILE_ROOT_PACKAGE)) {
            String userRootEEPackage = this.additionalProperties.get(MICROPROFILE_ROOT_PACKAGE).toString();
            if (!packagePrefixImpliedByVersion.equals(userRootEEPackage)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Helidon version %s uses the %s namespace but options specified '%s'", version, packagePrefixImpliedByVersion, userRootEEPackage));
            }
            return userRootEEPackage;
        }
        return packagePrefixImpliedByVersion;
    }

    private String checkAndSelectRootEEDepPrefix(String version) {
        String mavenDepPrefixImpliedByVersion;
        String string = mavenDepPrefixImpliedByVersion = this.usesJakartaPrefix(version) ? MICROPROFILE_ROOT_PACKAGE_JAKARTA : MICROPROFILE_ROOT_PACKAGE_JAVAX;
        if (this.additionalProperties.containsKey(MICROPROFILE_ROOT_DEP_PREFIX)) {
            String userMavenDepPrefix = this.additionalProperties.get(MICROPROFILE_ROOT_DEP_PREFIX).toString();
            if (!mavenDepPrefixImpliedByVersion.equals(userMavenDepPrefix)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Helidon version %s uses the %s prefix for EE dependencies but options specified '%s'", version, mavenDepPrefixImpliedByVersion, userMavenDepPrefix));
            }
            return userMavenDepPrefix;
        }
        return mavenDepPrefixImpliedByVersion;
    }

    private boolean usesJakartaPackages(String version) {
        return !version.startsWith("2.") && !version.startsWith("1.");
    }

    private boolean usesJakartaPrefix(String version) {
        return !version.startsWith("1.");
    }

    protected void removeCliOptions(String ... opt) {
        List<String> opts = Arrays.asList(opt);
        Set<CliOption> forRemoval = this.cliOptions.stream().filter(cliOption -> opts.contains(cliOption.getOpt())).collect(Collectors.toSet());
        forRemoval.forEach(this.cliOptions::remove);
    }

    private String chooseExampleReturnTypeValue(CodegenOperation op) {
        if (op.returnType == null) {
            return VALIDATION_ARTIFACT_PREFIX_JAVAX;
        }
        if (op.returnContainer != null) {
            return "java.util.Collections.empty" + EXAMPLE_RETURN_VALUES.get(op.returnContainer) + "()";
        }
        switch (op.returnType) {
            case "Integer": {
                return "new Integer(0)";
            }
            case "byte[]": {
                return "new byte[0]";
            }
            case "Float": {
                return "new Float(0.0f)";
            }
            case "boolean": {
                return "false";
            }
            case "Long": {
                return "new Long(0L)";
            }
            case "Object": {
                return "new Object()";
            }
            case "String": {
                return "\"\"";
            }
            case "Boolean": {
                return "new Boolean(false)";
            }
            case "Double": {
                return "new Double(0.0d)";
            }
        }
        return "null";
    }
}

