/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.JavaMicronautAbstractCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.StringUtils;

public class JavaMicronautServerCodegen
extends JavaMicronautAbstractCodegen {
    public static final String OPT_CONTROLLER_PACKAGE = "controllerPackage";
    public static final String OPT_GENERATE_CONTROLLER_FROM_EXAMPLES = "generateControllerFromExamples";
    public static final String OPT_GENERATE_CONTROLLER_AS_ABSTRACT = "generateControllerAsAbstract";
    public static final String OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED = "generateOperationsToReturnNotImplemented";
    public static final String EXTENSION_ROLES = "x-roles";
    public static final String ANONYMOUS_ROLE_KEY = "isAnonymous()";
    public static final String ANONYMOUS_ROLE = "SecurityRule.IS_ANONYMOUS";
    public static final String AUTHORIZED_ROLE_KEY = "isAuthorized()";
    public static final String AUTHORIZED_ROLE = "SecurityRule.IS_AUTHENTICATED";
    public static final String DENY_ALL_ROLE_KEY = "denyAll()";
    public static final String DENY_ALL_ROLE = "SecurityRule.DENY_ALL";
    public static final String NAME = "java-micronaut-server";
    protected String controllerPackage = "org.openapitools.controller";
    protected boolean generateControllerAsAbstract = false;
    protected boolean generateOperationsToReturnNotImplemented = true;
    protected boolean generateControllerFromExamples = false;
    protected boolean useAuth = true;
    protected String controllerPrefix = "";
    protected String controllerSuffix = "Controller";
    protected String apiPrefix = "Abstract";
    protected String apiSuffix = "Controller";

    public JavaMicronautServerCodegen() {
        this.title = "OpenAPI Micronaut Server";
        this.apiPackage = "org.openapitools.api";
        this.apiDocPath = "docs/controllers";
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.additionalProperties.put("server", "true");
        this.cliOptions.add(new CliOption(OPT_CONTROLLER_PACKAGE, "The package in which controllers will be generated").defaultValue(this.apiPackage));
        this.cliOptions.removeIf(c -> c.getOpt().equals("apiPackage"));
        this.cliOptions.add(CliOption.newBoolean(OPT_GENERATE_CONTROLLER_FROM_EXAMPLES, "Generate the implementation of controller and tests from parameter and return examples that will verify that the api works as desired (for testing)", this.generateControllerFromExamples));
        this.cliOptions.add(CliOption.newBoolean(OPT_GENERATE_CONTROLLER_AS_ABSTRACT, "Generate an abstract class for controller to be extended. (apiPackage is then used for the abstract class, and controllerPackage is used for implementation that extends it.)", this.generateControllerAsAbstract));
        this.cliOptions.add(CliOption.newBoolean(OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED, "Return HTTP 501 Not Implemented instead of an empty response in the generated controller methods.", this.generateOperationsToReturnNotImplemented));
        this.cliOptions.add(CliOption.newBoolean("useAuth", "Whether to import authorization and to annotate controller methods accordingly", this.useAuth));
        this.typeMapping.put("file", "CompletedFileUpload");
        this.importMapping.put("CompletedFileUpload", "io.micronaut.http.multipart.CompletedFileUpload");
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getHelp() {
        return "Generates a Java Micronaut Server.";
    }

    @Override
    public void processOpts() {
        if (this.additionalProperties.containsKey(OPT_GENERATE_CONTROLLER_AS_ABSTRACT)) {
            this.generateControllerAsAbstract = this.convertPropertyToBoolean(OPT_GENERATE_CONTROLLER_AS_ABSTRACT);
        }
        this.writePropertyBack(OPT_GENERATE_CONTROLLER_AS_ABSTRACT, this.generateControllerAsAbstract);
        if (this.additionalProperties.containsKey(OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED)) {
            this.generateOperationsToReturnNotImplemented = this.convertPropertyToBoolean(OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED);
        }
        this.writePropertyBack(OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED, this.generateOperationsToReturnNotImplemented);
        if (this.additionalProperties.containsKey(OPT_CONTROLLER_PACKAGE)) {
            this.controllerPackage = (String)this.additionalProperties.get(OPT_CONTROLLER_PACKAGE);
        } else if (!this.generateControllerAsAbstract && this.additionalProperties.containsKey("apiPackage")) {
            this.controllerPackage = (String)this.additionalProperties.get("apiPackage");
        }
        this.additionalProperties.put(OPT_CONTROLLER_PACKAGE, this.controllerPackage);
        if (!this.generateControllerAsAbstract) {
            this.apiPackage = this.controllerPackage;
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_GENERATE_CONTROLLER_FROM_EXAMPLES)) {
            this.generateControllerFromExamples = this.convertPropertyToBoolean(OPT_GENERATE_CONTROLLER_FROM_EXAMPLES);
        }
        this.writePropertyBack(OPT_GENERATE_CONTROLLER_FROM_EXAMPLES, this.generateControllerFromExamples);
        if (this.additionalProperties.containsKey("useAuth")) {
            this.useAuth = this.convertPropertyToBoolean("useAuth");
        }
        this.writePropertyBack("useAuth", this.useAuth);
        this.apiTemplateFiles.clear();
        if (this.generateControllerAsAbstract) {
            this.setApiNamePrefix(this.apiPrefix);
            this.setApiNameSuffix(this.apiSuffix);
        } else {
            this.setApiNamePrefix(this.controllerPrefix);
            this.setApiNameSuffix(this.controllerSuffix);
        }
        this.apiTemplateFiles.put("server/controller.mustache", ".java");
        this.supportingFiles.add(new SupportingFile("server/doc/README.mustache", "", "README.md").doNotOverwrite());
        this.apiDocTemplateFiles.clear();
        this.apiDocTemplateFiles.put("server/doc/controller_doc.mustache", ".md");
        this.apiTestTemplateFiles.clear();
        if (this.generateControllerAsAbstract) {
            this.apiTestTemplateFiles.put("server/controllerImplementation.mustache", ".java");
        }
        if (this.testTool.equals("junit")) {
            this.apiTestTemplateFiles.put("server/test/controller_test.mustache", ".java");
        } else if (this.testTool.equals("spock")) {
            this.apiTestTemplateFiles.put("server/test/controller_test.groovy.mustache", ".groovy");
        }
        String invokerFolder = (this.sourceFolder + "/" + this.invokerPackage).replace('.', '/');
        this.supportingFiles.add(new SupportingFile("common/configuration/Application.mustache", invokerFolder, "Application.java").doNotOverwrite());
    }

    @Override
    public String apiTestFileFolder() {
        return super.getOutputDir();
    }

    @Override
    public String apiTestFilename(String templateName, String tag) {
        if (this.generateControllerAsAbstract && templateName.contains("controllerImplementation")) {
            String implementationFolder = this.outputFolder + File.separator + this.sourceFolder + File.separator + this.controllerPackage.replace('.', File.separatorChar);
            return (implementationFolder + File.separator + StringUtils.camelize(this.controllerPrefix + "_" + tag + "_" + this.controllerSuffix) + ".java").replace('/', File.separatorChar);
        }
        String suffix = this.apiTestTemplateFiles().get(templateName);
        return super.apiTestFileFolder() + File.separator + this.toApiTestFilename(tag) + suffix;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        super.setParameterExampleValue(p);
        if (p.isFile) {
            p.example = "null";
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        OperationMap operations = objs.getOperations();
        String controllerClassname = StringUtils.camelize(this.controllerPrefix + "_" + operations.getPathPrefix() + "_" + this.controllerSuffix);
        objs.put("controllerClassname", controllerClassname);
        List allOperations = (List)operations.get("operation");
        if (this.useAuth) {
            for (CodegenOperation operation : allOperations) {
                if (!operation.vendorExtensions.containsKey(EXTENSION_ROLES)) {
                    String role2 = operation.hasAuthMethods ? AUTHORIZED_ROLE : ANONYMOUS_ROLE;
                    operation.vendorExtensions.put(EXTENSION_ROLES, Collections.singletonList(role2));
                    continue;
                }
                List roles = (List)operation.vendorExtensions.get(EXTENSION_ROLES);
                roles = roles.stream().map(role -> {
                    switch (role) {
                        case "isAnonymous()": {
                            return ANONYMOUS_ROLE;
                        }
                        case "isAuthorized()": {
                            return AUTHORIZED_ROLE;
                        }
                        case "denyAll()": {
                            return DENY_ALL_ROLE;
                        }
                    }
                    return "\"" + this.escapeText((String)role) + "\"";
                }).collect(Collectors.toList());
                operation.vendorExtensions.put(EXTENSION_ROLES, roles);
            }
        }
        return objs;
    }
}

