/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.gradle;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RelativePath;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.tasks.InputFiles;
import org.jetbrains.annotations.NotNull;
import org.opencrx.gradle.ArchiveTask;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/opencrx/gradle/EarTask;", "Lorg/opencrx/gradle/ArchiveTask;", "()V", "libs", "Lorg/gradle/api/artifacts/Configuration;", "getLibs", "()Lorg/gradle/api/artifacts/Configuration;", "setLibs", "(Lorg/gradle/api/artifacts/Configuration;)V", "modules", "Ljava/io/File;", "getModules", "()Ljava/io/File;", "setModules", "(Ljava/io/File;)V", "gradle"})
public class EarTask
extends ArchiveTask {
    @InputFiles
    @NotNull
    private Configuration libs;
    @InputFiles
    @NotNull
    private File modules;

    public EarTask() {
        Configuration configuration = this.getProject().getConfigurations().getByName("earlib");
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.getConfigurations().getByName(\"earlib\")");
        this.libs = configuration;
        this.modules = new File(this.getDeliverDir(), "deployment-unit");
        this.getDestinationDirectory().set(new File(this.getDeliverDir(), "deployment-unit"));
        this.getArchiveFileName().set((Object)(this.getAppTargetName() + ".ear"));
        this.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        this.setIncludeEmptyDirs(false);
        this.manifest(new Action(){

            public final void execute(@NotNull Manifest $this$manifest) {
                Intrinsics.checkNotNullParameter((Object)$this$manifest, (String)"$this$manifest");
                $this$manifest.attributes(this.getManifest("openCRX/" + this.getProviderName() + " EAR", this.getAppTargetName() + ".ear"));
            }
        });
        FileTree fileTree = this.getProject().zipTree((Object)this.getProject().getConfigurations().getByName("opencrxCoreConfig").getSingleFile());
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"project.zipTree(project.\u2026xCoreConfig\").singleFile)");
        FileTree opencrxCoreConfigFiles = fileTree;
        final Ref.IntRef nSegmentsAppSourceName = new Ref.IntRef();
        String[] stringArray = new String[]{this.getAppSourceName()};
        nSegmentsAppSourceName.element = new RelativePath(false, stringArray).getSegments().length;
        this.from(this.modules, 2.INSTANCE);
        this.from(this.libs, 3.INSTANCE);
        this.from(new File(this.getProjectDir(), "src/data/" + this.getAppSourceName() + ".ear/META-INF"), new Action(){

            public final void execute(@NotNull CopySpec $this$from) {
                Intrinsics.checkNotNullParameter((Object)$this$from, (String)"$this$from");
                $this$from.into((Object)"META-INF");
                String[] stringArray = new String[]{"application.xml", "*.policy", "mime.types"};
                $this$from.include(stringArray);
                $this$from.filter(new Transformer(){

                    public final String transform(@NotNull String line) {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        return this.archiveFilter(line);
                    }
                });
            }
        });
        this.from(opencrxCoreConfigFiles, new Action(){

            public final void execute(@NotNull CopySpec $this$from) {
                Intrinsics.checkNotNullParameter((Object)$this$from, (String)"$this$from");
                String[] stringArray = new String[]{"opencrx-core-CRX.ear/META-INF/application.xml", this.getAppSourceName() + ".ear/META-INF/*.policy", this.getAppSourceName() + ".ear/META-INF/mime.types"};
                $this$from.include(stringArray);
                $this$from.eachFile(new Action(){

                    public final void execute(@NotNull FileCopyDetails $this$eachFile) {
                        Intrinsics.checkNotNullParameter((Object)$this$eachFile, (String)"$this$eachFile");
                        String[] stringArray = $this$eachFile.getRelativePath().getSegments();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"relativePath.segments");
                        Collection $this$toTypedArray$iv = ArraysKt.drop((Object[])stringArray, (int)nSegmentsAppSourceName.element);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                        $this$eachFile.setRelativePath(new RelativePath(true, Arrays.copyOf(stringArray2, stringArray2.length)));
                    }
                });
                $this$from.filter(new Transformer(){

                    public final String transform(@NotNull String line) {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        return this.archiveFilter(line);
                    }
                });
            }
        });
    }

    @NotNull
    public final Configuration getLibs() {
        return this.libs;
    }

    public final void setLibs(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"<set-?>");
        this.libs = configuration;
    }

    @NotNull
    public final File getModules() {
        return this.modules;
    }

    public final void setModules(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.modules = file;
    }
}

