/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.gradle;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RelativePath;
import org.gradle.api.java.archives.Manifest;
import org.jetbrains.annotations.NotNull;
import org.opencrx.gradle.ArchiveTask;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/opencrx/gradle/ImapWarTask;", "Lorg/opencrx/gradle/ArchiveTask;", "()V", "gradle"})
public class ImapWarTask
extends ArchiveTask {
    public ImapWarTask() {
        this.getDestinationDirectory().set(new File(this.getDeliverDir(), "deployment-unit"));
        this.getArchiveFileName().set((Object)(this.getWebAppName("imap") + ".war"));
        this.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        this.setIncludeEmptyDirs(false);
        this.filter(new Transformer(){

            public final String transform(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                return this.archiveFilter(line);
            }
        });
        this.manifest(new Action(){

            public final void execute(@NotNull Manifest $this$manifest) {
                Intrinsics.checkNotNullParameter((Object)$this$manifest, (String)"$this$manifest");
                $this$manifest.attributes(this.getManifest("openCRX/Imap " + this.getProviderName() + " WAR", "opencrx-imap-" + this.getProviderName() + ".war"));
            }
        });
        FileTree fileTree = this.getProject().zipTree((Object)this.getProject().getConfigurations().getByName("opencrxCoreConfig").getSingleFile());
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"project.zipTree(project.\u2026xCoreConfig\").singleFile)");
        FileTree opencrxCoreConfigFiles = fileTree;
        final Ref.IntRef nSegmentsDataDirGeneric = new Ref.IntRef();
        String[] stringArray = new String[]{this.getDataDirGeneric()};
        nSegmentsDataDirGeneric.element = new RelativePath(false, stringArray).getSegments().length;
        this.from(new File(this.getDataHome(), this.getDataDir() + ".imap/META-INF"), new Action(){

            public final void execute(@NotNull CopySpec $this$from) {
                Intrinsics.checkNotNullParameter((Object)$this$from, (String)"$this$from");
                $this$from.into((Object)"META-INF");
                $this$from.filter(new Transformer(){

                    public final String transform(@NotNull String line) {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        return this.archiveFilter(line);
                    }
                });
            }
        });
        this.from(opencrxCoreConfigFiles, new Action(){

            public final void execute(@NotNull CopySpec $this$from) {
                Intrinsics.checkNotNullParameter((Object)$this$from, (String)"$this$from");
                String[] stringArray = new String[]{this.getDataDirGeneric() + ".imap/META-INF/"};
                $this$from.include(stringArray);
                $this$from.eachFile(new Action(){

                    public final void execute(@NotNull FileCopyDetails $this$eachFile) {
                        Intrinsics.checkNotNullParameter((Object)$this$eachFile, (String)"$this$eachFile");
                        String[] stringArray = $this$eachFile.getRelativePath().getSegments();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"relativePath.segments");
                        Collection $this$toTypedArray$iv = ArraysKt.drop((Object[])stringArray, (int)nSegmentsDataDirGeneric.element);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                        $this$eachFile.setRelativePath(new RelativePath(true, Arrays.copyOf(stringArray2, stringArray2.length)));
                    }
                });
                $this$from.filter(new Transformer(){

                    public final String transform(@NotNull String line) {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        return this.archiveFilter(line);
                    }
                });
            }
        });
        this.from(new File(this.getDataHome(), this.getDataDir() + ".imap/WEB-INF"), new Action(){

            public final void execute(@NotNull CopySpec $this$from) {
                Intrinsics.checkNotNullParameter((Object)$this$from, (String)"$this$from");
                $this$from.into((Object)"WEB-INF");
                String[] stringArray = new String[]{"web.xml", "*.xml"};
                $this$from.include(stringArray);
                stringArray = new String[]{"*/*"};
                $this$from.exclude(stringArray);
                $this$from.filter(new Transformer(){

                    public final String transform(@NotNull String line) {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        return this.archiveFilter(line);
                    }
                });
            }
        });
        this.from(opencrxCoreConfigFiles, new Action(){

            public final void execute(@NotNull CopySpec $this$from) {
                Intrinsics.checkNotNullParameter((Object)$this$from, (String)"$this$from");
                String[] stringArray = new String[]{this.getDataDirGeneric() + ".imap/WEB-INF/web.xml", this.getDataDirGeneric() + ".imap/WEB-INF/*.xml"};
                $this$from.include(stringArray);
                stringArray = new String[]{"*/*"};
                $this$from.exclude(stringArray);
                $this$from.eachFile(new Action(){

                    public final void execute(@NotNull FileCopyDetails $this$eachFile) {
                        Intrinsics.checkNotNullParameter((Object)$this$eachFile, (String)"$this$eachFile");
                        String[] stringArray = $this$eachFile.getRelativePath().getSegments();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"relativePath.segments");
                        Collection $this$toTypedArray$iv = ArraysKt.drop((Object[])stringArray, (int)nSegmentsDataDirGeneric.element);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                        $this$eachFile.setRelativePath(new RelativePath(true, Arrays.copyOf(stringArray2, stringArray2.length)));
                    }
                });
                $this$from.filter(new Transformer(){

                    public final String transform(@NotNull String line) {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        return this.archiveFilter(line);
                    }
                });
            }
        });
        this.from(new File(this.getDataHome(), this.getDataDir() + ".imap"), new Action(){

            public final void execute(@NotNull CopySpec $this$from) {
                Intrinsics.checkNotNullParameter((Object)$this$from, (String)"$this$from");
                String[] stringArray = new String[]{"**/*.*"};
                $this$from.include(stringArray);
                $this$from.filter(new Transformer(){

                    public final String transform(@NotNull String line) {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        return this.archiveFilter(line);
                    }
                });
            }
        });
        this.from(opencrxCoreConfigFiles, new Action(){

            public final void execute(@NotNull CopySpec $this$from) {
                Intrinsics.checkNotNullParameter((Object)$this$from, (String)"$this$from");
                String[] stringArray = new String[]{this.getDataDirGeneric() + ".imap/**/*.*"};
                $this$from.include(stringArray);
                $this$from.eachFile(new Action(){

                    public final void execute(@NotNull FileCopyDetails $this$eachFile) {
                        Intrinsics.checkNotNullParameter((Object)$this$eachFile, (String)"$this$eachFile");
                        String[] stringArray = $this$eachFile.getRelativePath().getSegments();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"relativePath.segments");
                        Collection $this$toTypedArray$iv = ArraysKt.drop((Object[])stringArray, (int)nSegmentsDataDirGeneric.element);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                        $this$eachFile.setRelativePath(new RelativePath(true, Arrays.copyOf(stringArray2, stringArray2.length)));
                    }
                });
                $this$from.filter(new Transformer(){

                    public final String transform(@NotNull String line) {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        return this.archiveFilter(line);
                    }
                });
            }
        });
    }
}

