/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;

@Beta
public abstract class AbstractEffectiveStatementInference<T extends EffectiveStatement<?, ?>>
implements EffectiveStatementInference {
    private final @NonNull EffectiveModelContext modelContext;

    protected AbstractEffectiveStatementInference(@NonNull EffectiveModelContext modelContext) {
        this.modelContext = Objects.requireNonNull(modelContext);
    }

    public final EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    public abstract List<T> statementPath();

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("modelContext", (Object)this.modelContext);
    }

    @Beta
    public static abstract class WithPath<T extends EffectiveStatement<?, ?>>
    extends AbstractEffectiveStatementInference<T> {
        private final @NonNull List<T> path;

        protected WithPath(@NonNull EffectiveModelContext modelContext, @NonNull ImmutableList<T> path) {
            super(modelContext);
            this.path = (List)Objects.requireNonNull(path);
        }

        protected WithPath(@NonNull EffectiveModelContext modelContext, @NonNull List<? extends T> path) {
            super(modelContext);
            this.path = ImmutableList.copyOf(path);
        }

        @Override
        public final List<T> statementPath() {
            return this.path;
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("path", this.path);
        }
    }
}

