/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.openhab.tools.analysis.tools.AbstractChecker;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="checkstyle", requiresDependencyResolution=ResolutionScope.COMPILE)
public class CheckstyleChecker
extends AbstractChecker {
    @Parameter(property="checkstyle.ruleset")
    protected String checkstyleRuleset;
    @Parameter(property="checkstyle.filter")
    protected String checkstyleFilter;
    @Parameter(property="maven.checkstyle.version", defaultValue="2.17")
    private String checkstyleMavenVersion;
    @Parameter
    private List<Dependency> checkstylePlugins = new ArrayList<Dependency>();
    @Parameter(property="checkstyle.ruleset.properties")
    private String checkstyleProperties;
    private static final String CHECKSTYLE_PROPERTIES_FILE = "configuration/checkstyle.properties";
    private static final String MAVEN_CHECKSTYLE_PLUGIN_GOAL = "checkstyle";
    private static final String MAVEN_CHECKSTYLE_PLUGIN_ARTIFACT_ID = "maven-checkstyle-plugin";
    private static final String MAVEN_CHECKSTYLE_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private static final String DEFAULT_RULE_SET_XML = "rulesets/checkstyle/rules.xml";
    private static final String DEFAULT_FILTER_XML = "rulesets/checkstyle/suppressions.xml";
    private static final String CHECKSTYLE_RULE_SET_PROPERTY = "checkstyle.config.location";
    private static final String CHECKSTYLE_SUPPRESSION_PROPERTY = "checkstyle.suppressions.location";
    private static final String CHECKSTYLE_RULE_SET_PROPERTIES_PROPERTY = "checkstyle.properties.location";

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        Properties userProps = this.loadPropertiesFromFile(CHECKSTYLE_PROPERTIES_FILE);
        String ruleset = this.getLocation(this.checkstyleRuleset, DEFAULT_RULE_SET_XML);
        log.debug((CharSequence)("Ruleset location is " + ruleset));
        userProps.setProperty(CHECKSTYLE_RULE_SET_PROPERTY, ruleset);
        String supression = this.getLocation(this.checkstyleFilter, DEFAULT_FILTER_XML);
        log.debug((CharSequence)("Filter location is " + supression));
        userProps.setProperty(CHECKSTYLE_SUPPRESSION_PROPERTY, supression);
        if (this.checkstyleProperties != null) {
            String rulesetProperties = this.getLocation(this.checkstyleProperties, "");
            log.debug((CharSequence)("Ruleset properties location is " + rulesetProperties));
            userProps.setProperty(CHECKSTYLE_RULE_SET_PROPERTIES_PROPERTY, rulesetProperties);
        }
        this.checkstylePlugins.add(MojoExecutor.dependency((String)"org.openhab.tools.sat.custom-checks", (String)MAVEN_CHECKSTYLE_PLUGIN_GOAL, (String)this.plugin.getVersion()));
        this.checkstylePlugins.add(MojoExecutor.dependency((String)"com.puppycrawl.tools", (String)MAVEN_CHECKSTYLE_PLUGIN_GOAL, (String)"8.1"));
        this.checkstylePlugins.forEach(this.logDependency());
        Xpp3Dom config = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"sourceDirectory", (String)this.mavenProject.getBasedir().toString())});
        this.executeCheck(MAVEN_CHECKSTYLE_PLUGIN_GROUP_ID, MAVEN_CHECKSTYLE_PLUGIN_ARTIFACT_ID, this.checkstyleMavenVersion, MAVEN_CHECKSTYLE_PLUGIN_GOAL, config, this.checkstylePlugins);
        log.debug((CharSequence)"Checkstyle execution has been finished.");
    }
}

