/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.app;

import info.aduna.lang.ObjectUtil;
import java.util.Locale;

public class AppVersion
implements Comparable<AppVersion> {
    private int major;
    private int minor;
    private int micro;
    private String modifier;

    public AppVersion() {
        this(-1, -1, -1, null);
    }

    public AppVersion(int major, int minor) {
        this(major, minor, -1, null);
    }

    public AppVersion(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public AppVersion(int major, int minor, String modifier) {
        this(major, minor, -1, modifier);
    }

    public AppVersion(int major, int minor, int micro, String modifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.modifier = modifier;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public void setMicro(int micro) {
        this.micro = micro;
    }

    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public boolean equals(Object other) {
        boolean isEqual = false;
        if (other instanceof AppVersion) {
            AppVersion o = (AppVersion)other;
            boolean bl = isEqual = this.major == o.major && this.minor == o.minor && this.micro == o.micro;
            if (isEqual) {
                isEqual = this.modifier == o.modifier || this.modifier != null && this.modifier.equalsIgnoreCase(o.modifier);
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = 31 * (31 * this.major + this.minor);
        if (this.micro > 0) {
            hash += this.micro;
        }
        if (this.modifier != null) {
            hash ^= this.modifier.toLowerCase(Locale.ENGLISH).hashCode();
        }
        return hash;
    }

    public boolean olderThan(AppVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean newerThan(AppVersion other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public int compareTo(AppVersion other) {
        int result = this.major - other.major;
        if (result == 0) {
            result = this.minor - other.minor;
        }
        if (result == 0) {
            result = this.micro - other.micro;
        }
        if (result == 0 && !ObjectUtil.nullEquals((Object)this.modifier, (Object)other.modifier)) {
            result = this.modifier == null ? 1 : (other.modifier == null ? -1 : this.modifier.compareToIgnoreCase(other.modifier));
        }
        return result;
    }

    public static AppVersion parse(String versionString) {
        if (versionString.equals("dev")) {
            return new AppVersion(-1, -1, "dev");
        }
        int minorSeperator = versionString.indexOf(46);
        int microSeperator = versionString.indexOf(46, minorSeperator + 1);
        int modifierSeperator = versionString.indexOf(45, Math.max(minorSeperator, microSeperator));
        if (minorSeperator == -1) {
            throw new NumberFormatException("Illegal version string: " + versionString);
        }
        String major = versionString.substring(0, minorSeperator);
        String minor = null;
        String micro = null;
        String modifier = null;
        if (microSeperator == -1) {
            if (modifierSeperator == -1) {
                minor = versionString.substring(minorSeperator + 1);
            } else {
                minor = versionString.substring(minorSeperator + 1, modifierSeperator);
                modifier = versionString.substring(modifierSeperator + 1);
            }
        } else {
            minor = versionString.substring(minorSeperator + 1, microSeperator);
            if (modifierSeperator == -1) {
                micro = versionString.substring(microSeperator + 1);
            } else {
                micro = versionString.substring(microSeperator + 1, modifierSeperator);
                modifier = versionString.substring(modifierSeperator + 1);
            }
        }
        int majorInt = Integer.parseInt(major);
        int minorInt = Integer.parseInt(minor);
        int microInt = micro == null ? -1 : Integer.parseInt(micro);
        return new AppVersion(majorInt, minorInt, microInt, modifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        if (this.major >= 0) {
            sb.append(this.major).append('.').append(this.minor);
        }
        if (this.micro >= 0) {
            sb.append('.').append(this.micro);
        }
        if (this.modifier != null) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(this.modifier);
        }
        return sb.toString();
    }
}

