/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.app.logging.logback;

import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.util.OptionHelper;
import info.aduna.logging.LogReader;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public class LogConfigurator
extends JoranConfigurator {
    Map<String, String> logReaderClassNames = new HashMap<String, String>();
    Map<String, Appender<?>> appenders = new HashMap();
    String defaultAppender = null;

    public LogReader getDefaultLogReader() {
        if (this.defaultAppender == null && this.appenders.keySet().iterator().hasNext()) {
            this.defaultAppender = this.appenders.keySet().iterator().next();
        }
        return this.getLogReader(this.defaultAppender);
    }

    public LogReader getLogReader(String appenderName) {
        if (appenderName != null) {
            String className = this.logReaderClassNames.get(appenderName);
            if (className != null) {
                try {
                    LogReader logReader = (LogReader)OptionHelper.instantiateByClassName((String)className, LogReader.class, (Context)this.context);
                    logReader.setAppender(this.appenders.get(appenderName));
                    return logReader;
                }
                catch (Exception ex) {
                    System.err.println("Could not create logreader of type " + className + " !");
                    ex.printStackTrace();
                }
            } else {
                System.err.println("Could not find logreader for appender " + appenderName + " !");
            }
        }
        return null;
    }

    public void addInstanceRules(RuleStore rs) {
        super.addInstanceRules(rs);
        rs.addRule(new ElementSelector("configuration/appender/logreader"), (Action)new LogReaderAction());
    }

    public class LogReaderAction
    extends Action {
        String className;
        boolean def = false;

        public void begin(InterpretationContext ec, String name, Attributes attributes) {
            this.className = attributes.getValue("class");
            this.def = attributes.getValue("default") != null && attributes.getValue("default").equalsIgnoreCase("true");
            ec.pushObject((Object)this.className);
        }

        public void end(InterpretationContext ec, String arg1) {
            Object o = ec.peekObject();
            if (o != this.className) {
                this.addWarn("The object on the top the of the stack is not the logreader classname pushed earlier.");
            } else {
                ec.popObject();
                Appender appender = (Appender)ec.peekObject();
                LogConfigurator.this.logReaderClassNames.put(appender.getName(), this.className);
                LogConfigurator.this.appenders.put(appender.getName(), appender);
                if (this.def) {
                    LogConfigurator.this.defaultAppender = appender.getName();
                }
            }
        }
    }
}

