/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.app.logging.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import info.aduna.app.logging.base.LogConfigurationBase;
import info.aduna.app.logging.logback.LogConfigurator;
import info.aduna.app.util.ConfigurationUtil;
import info.aduna.io.IOUtil;
import info.aduna.logging.LogReader;
import info.aduna.logging.file.logback.FileLogReader;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackConfiguration
extends LogConfigurationBase {
    public static final String LOGGING_DIR_PROPERTY = "info.aduna.logging.dir";
    private static final String LOGBACK_CONFIG_FILE = "logback.xml";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private File configFile;
    private LogConfigurator configurator = null;

    @Override
    public void init() throws IOException {
        this.configFile = this.getConfigFile();
        this.load();
        this.logger.info("Logback logging API implementation is configured.");
        this.logger.debug("Log dir: {}", (Object)this.getLoggingDir().getAbsolutePath());
        this.save();
    }

    @Override
    public void load() throws IOException {
        try {
            if (System.getProperty(LOGGING_DIR_PROPERTY) == null) {
                System.setProperty(LOGGING_DIR_PROPERTY, this.getLoggingDir().getAbsolutePath());
            }
        }
        catch (SecurityException e) {
            System.out.println("Not allowed to read or write system property 'info.aduna.logging.dir'");
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            this.configurator = new LogConfigurator();
            this.configurator.setContext((Context)lc);
            lc.reset();
            this.configurator.doConfigure(this.configFile);
        }
        catch (JoranException je) {
            System.out.println("Logback configuration error");
            je.printStackTrace();
            StatusPrinter.print((Context)lc);
        }
    }

    @Override
    public void save() throws IOException {
    }

    @Override
    public void destroy() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.reset();
    }

    private File getConfigFile() throws IOException {
        File f = new File(this.getConfDir(), LOGBACK_CONFIG_FILE);
        if (!f.exists() || !f.canRead()) {
            String content = ConfigurationUtil.loadConfigurationContents(LOGBACK_CONFIG_FILE);
            content = content.replace("${logging.main.file}", "main.log");
            content = content.replace("${logging.event.user.file}", "user-event.log");
            content = content.replace("${logging.event.admin.file}", "admin-event.log");
            content = content.replace("${logging.event.user.logger}", "event.user");
            content = content.replace("${logging.event.admin.logger}", "event.admin");
            if (!f.getParentFile().mkdirs() && !f.getParentFile().canWrite()) {
                throw new IOException("Not allowed to write logging configuration file to " + f.getParent());
            }
            IOUtil.writeString((String)content, (File)f);
        }
        return f;
    }

    @Override
    public LogReader getLogReader(String appender) {
        return this.configurator.getLogReader(appender);
    }

    @Override
    public LogReader getDefaultLogReader() {
        LogReader logReader = this.configurator.getDefaultLogReader();
        if (logReader != null) {
            return logReader;
        }
        return new FileLogReader(new File(this.getLoggingDir(), "main.log"));
    }
}

