/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.app.util;

import info.aduna.io.IOUtil;
import info.aduna.io.ResourceUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConfigurationUtil {
    public static String loadConfigurationContents(File file) throws IOException {
        String result = null;
        if (file.exists()) {
            result = IOUtil.readString((File)file);
        }
        return result;
    }

    public static String loadConfigurationContents(String resourceName) throws IOException {
        String result = null;
        InputStream in = ResourceUtil.getInputStream((String)ConfigurationUtil.getResourceName(resourceName));
        if (in == null) {
            in = ResourceUtil.getInputStream((String)ConfigurationUtil.getDefaultResourceName(resourceName));
        }
        if (in != null) {
            result = IOUtil.readString((InputStream)in);
        }
        return result;
    }

    public static Properties loadConfigurationProperties(File file, Properties defaults) throws IOException {
        Properties result = null;
        result = file.exists() ? IOUtil.readProperties((File)file, (Properties)defaults) : new Properties(defaults);
        return result;
    }

    public static Properties loadConfigurationProperties(String resourceName, Properties defaults) throws IOException {
        Properties result = null;
        String defaultResourceName = ConfigurationUtil.getDefaultResourceName(resourceName);
        Properties defaultResult = null;
        InputStream in = ResourceUtil.getInputStream((String)defaultResourceName);
        defaultResult = in != null ? IOUtil.readProperties((InputStream)in, (Properties)defaults) : new Properties(defaults);
        in = ResourceUtil.getInputStream((String)ConfigurationUtil.getResourceName(resourceName));
        result = in != null ? IOUtil.readProperties((InputStream)in, (Properties)defaultResult) : new Properties(defaultResult);
        return result;
    }

    private static String getResourceName(String resourceName) {
        StringBuilder result = new StringBuilder("/info/aduna/app/config/");
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        result.append(resourceName);
        return result.toString();
    }

    private static String getDefaultResourceName(String resourceName) {
        StringBuilder result = new StringBuilder("/info/aduna/app/config/defaults/");
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        result.append(resourceName);
        return result.toString();
    }

    public static void saveConfigurationContents(String contents, File file) throws IOException {
        if (file.getParentFile().mkdirs() || file.getParentFile().canWrite()) {
            IOUtil.writeString((String)contents, (File)file);
        }
    }

    public static void saveConfigurationProperties(Properties props, File file, boolean includeDefaults) throws IOException {
        if (file.getParentFile().mkdirs() || file.getParentFile().canWrite()) {
            IOUtil.writeProperties((Properties)props, (File)file, (boolean)includeDefaults);
        }
    }
}

