/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.rdfjson;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.io.input.BOMInputStream;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.helpers.RDFJSONParserSettings;
import org.openrdf.rio.helpers.RDFParserBase;
import org.openrdf.rio.rdfjson.RDFJSONUtility;

public class RDFJSONParser
extends RDFParserBase
implements RDFParser {
    private final RDFFormat actualFormat;

    public RDFJSONParser() {
        this(RDFFormat.RDFJSON);
    }

    public RDFJSONParser(RDFFormat actualFormat) {
        this.actualFormat = actualFormat;
    }

    public RDFFormat getRDFFormat() {
        return this.actualFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream, String baseUri) throws IOException, RDFParseException, RDFHandlerException {
        if (this.rdfHandler != null) {
            this.rdfHandler.startRDF();
        }
        JsonParser jp = null;
        try {
            jp = RDFJSONUtility.JSON_FACTORY.createParser((InputStream)new BOMInputStream(inputStream, false));
            this.rdfJsonToHandlerInternal(this.rdfHandler, this.valueFactory, jp);
        }
        catch (IOException e) {
            if (jp != null) {
                this.reportFatalError("Found IOException during parsing", e, jp.getCurrentLocation());
            } else {
                this.reportFatalError(e);
            }
        }
        finally {
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException e) {
                    this.reportFatalError("Found exception while closing JSON parser", e, jp.getCurrentLocation());
                }
            }
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.endRDF();
        }
    }

    protected Literal createLiteral(String nextValue, String nextLanguage, URI datatype, JsonLocation currentLocation) throws RDFParseException {
        return this.createLiteral(nextValue, nextLanguage, datatype, currentLocation.getLineNr(), currentLocation.getColumnNr());
    }

    protected void reportError(String msg, Throwable e, JsonLocation location, RioSetting<Boolean> setting) throws RDFParseException {
        this.reportError(msg, location.getLineNr(), location.getColumnNr(), setting);
    }

    protected void reportError(String msg, JsonLocation location, RioSetting<Boolean> setting) throws RDFParseException {
        this.reportError(msg, location.getLineNr(), location.getColumnNr(), setting);
    }

    protected void reportFatalError(String msg, Throwable e, JsonLocation location) throws RDFParseException {
        this.reportFatalError(msg, location.getLineNr(), location.getColumnNr());
    }

    protected void reportFatalError(String msg, JsonLocation location) throws RDFParseException {
        this.reportFatalError(msg, location.getLineNr(), location.getColumnNr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader reader, String baseUri) throws IOException, RDFParseException, RDFHandlerException {
        if (this.rdfHandler == null) {
            this.rdfHandler.startRDF();
        }
        JsonParser jp = null;
        try {
            jp = RDFJSONUtility.JSON_FACTORY.createParser(reader);
            this.rdfJsonToHandlerInternal(this.rdfHandler, this.valueFactory, jp);
        }
        catch (IOException e) {
            if (jp != null) {
                this.reportFatalError("Found IOException during parsing", e, jp.getCurrentLocation());
            } else {
                this.reportFatalError(e);
            }
        }
        finally {
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException e) {
                    this.reportFatalError("Found exception while closing JSON parser", e, jp.getCurrentLocation());
                }
            }
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.endRDF();
        }
    }

    private void rdfJsonToHandlerInternal(RDFHandler handler, ValueFactory vf, JsonParser jp) throws IOException, JsonParseException, RDFParseException, RDFHandlerException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            this.reportFatalError("Expected RDF/JSON document to start with an Object", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String subjStr = jp.getCurrentName();
            URI subject = null;
            Object object = subject = subjStr.startsWith("_:") ? vf.createBNode(subjStr.substring(2)) : vf.createURI(subjStr);
            if (jp.nextToken() != JsonToken.START_OBJECT) {
                this.reportFatalError("Expected subject value to start with an Object", jp.getCurrentLocation());
            }
            boolean foundPredicate = false;
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String predStr = jp.getCurrentName();
                URI predicate = vf.createURI(predStr);
                foundPredicate = true;
                if (jp.nextToken() != JsonToken.START_ARRAY) {
                    this.reportFatalError("Expected predicate value to start with an array", jp.getCurrentLocation());
                }
                boolean foundObject = false;
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
                        this.reportFatalError("Expected object value to start with an Object: subject=<" + subjStr + "> predicate=<" + predStr + ">", jp.getCurrentLocation());
                    }
                    String nextValue = null;
                    String nextType = null;
                    String nextDatatype = null;
                    String nextLanguage = null;
                    HashSet<String> nextContexts = new HashSet<String>(2);
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = jp.getCurrentName();
                        if ("value".equals(fieldName)) {
                            if (nextValue != null) {
                                this.reportError("Multiple values found for a single object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation(), (RioSetting<Boolean>)RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_VALUES);
                            }
                            jp.nextToken();
                            nextValue = jp.getText();
                            continue;
                        }
                        if ("type".equals(fieldName)) {
                            if (nextType != null) {
                                this.reportError("Multiple types found for a single object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation(), (RioSetting<Boolean>)RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_TYPES);
                            }
                            jp.nextToken();
                            nextType = jp.getText();
                            continue;
                        }
                        if ("lang".equals(fieldName)) {
                            if (nextLanguage != null) {
                                this.reportError("Multiple languages found for a single object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation(), (RioSetting<Boolean>)RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_LANGUAGES);
                            }
                            jp.nextToken();
                            nextLanguage = jp.getText();
                            continue;
                        }
                        if ("datatype".equals(fieldName)) {
                            if (nextDatatype != null) {
                                this.reportError("Multiple datatypes found for a single object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation(), (RioSetting<Boolean>)RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_DATATYPES);
                            }
                            jp.nextToken();
                            nextDatatype = jp.getText();
                            continue;
                        }
                        if ("graphs".equals(fieldName)) {
                            if (jp.nextToken() != JsonToken.START_ARRAY) {
                                this.reportError("Expected graphs to start with an array", jp.getCurrentLocation(), (RioSetting<Boolean>)RDFJSONParserSettings.SUPPORT_GRAPHS_EXTENSION);
                            }
                            while (jp.nextToken() != JsonToken.END_ARRAY) {
                                String nextGraph = jp.getText();
                                nextContexts.add(nextGraph);
                            }
                            continue;
                        }
                        this.reportError("Unrecognised JSON field name for object: subject=" + subjStr + " predicate=" + predStr + " fieldname=" + fieldName, jp.getCurrentLocation(), (RioSetting<Boolean>)RDFJSONParserSettings.FAIL_ON_UNKNOWN_PROPERTY);
                    }
                    Literal object2 = null;
                    if (nextType == null) {
                        this.reportFatalError("No type for object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
                    }
                    if (nextValue == null) {
                        this.reportFatalError("No value for object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
                    }
                    if ("literal".equals(nextType)) {
                        object2 = nextLanguage != null ? this.createLiteral(nextValue, nextLanguage, null, jp.getCurrentLocation()) : (nextDatatype != null ? this.createLiteral(nextValue, null, this.createURI(nextDatatype), jp.getCurrentLocation()) : this.createLiteral(nextValue, null, null, jp.getCurrentLocation()));
                    } else if ("bnode".equals(nextType)) {
                        if (nextLanguage != null) {
                            this.reportFatalError("Language was attached to a blank node object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
                        }
                        if (nextDatatype != null) {
                            this.reportFatalError("Datatype was attached to a blank node object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
                        }
                        object2 = vf.createBNode(nextValue.substring(2));
                    } else if ("uri".equals(nextType)) {
                        if (nextLanguage != null) {
                            this.reportFatalError("Language was attached to a uri object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
                        }
                        if (nextDatatype != null) {
                            this.reportFatalError("Datatype was attached to a uri object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
                        }
                        object2 = vf.createURI(nextValue);
                    }
                    foundObject = true;
                    if (!nextContexts.isEmpty()) {
                        for (String nextContext : nextContexts) {
                            URI context = nextContext.equals("null") ? null : vf.createURI(nextContext);
                            Statement st = vf.createStatement((Resource)subject, predicate, (Value)object2, (Resource)context);
                            if (handler == null) continue;
                            handler.handleStatement(st);
                        }
                        continue;
                    }
                    Statement st = vf.createStatement((Resource)subject, predicate, (Value)object2);
                    if (handler == null) continue;
                    handler.handleStatement(st);
                }
                if (foundObject) continue;
                this.reportFatalError("No object for predicate: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
            }
            if (foundPredicate) continue;
            this.reportFatalError("No predicate for object: subject=" + subjStr, jp.getCurrentLocation());
        }
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_DATATYPES);
        result.add(RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_LANGUAGES);
        result.add(RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_TYPES);
        result.add(RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_VALUES);
        result.add(RDFJSONParserSettings.FAIL_ON_UNKNOWN_PROPERTY);
        result.add(RDFJSONParserSettings.SUPPORT_GRAPHS_EXTENSION);
        return result;
    }
}

