/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.trix;

import info.aduna.xml.SimpleSAXAdapter;
import info.aduna.xml.SimpleSAXListener;
import info.aduna.xml.SimpleSAXParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.BOMInputStream;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.RDFParserBase;
import org.openrdf.rio.helpers.TriXParserSettings;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TriXParser
extends RDFParserBase {
    public TriXParser() {
    }

    public TriXParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public final RDFFormat getRDFFormat() {
        return RDFFormat.TRIX;
    }

    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.parse(new BOMInputStream(in, false));
    }

    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.parse(reader);
    }

    private void parse(Object inputStreamOrReader) throws IOException, RDFParseException, RDFHandlerException {
        try {
            if (this.rdfHandler != null) {
                this.rdfHandler.startRDF();
            }
            SimpleSAXParser saxParser = new SimpleSAXParser();
            saxParser.setPreserveWhitespace(true);
            saxParser.setListener((SimpleSAXListener)new TriXSAXHandler());
            if (inputStreamOrReader instanceof InputStream) {
                saxParser.parse((InputStream)inputStreamOrReader);
            } else {
                saxParser.parse((Reader)inputStreamOrReader);
            }
            if (this.rdfHandler != null) {
                this.rdfHandler.endRDF();
            }
        }
        catch (SAXParseException e) {
            Exception wrappedExc = e.getException();
            if (wrappedExc == null) {
                this.reportFatalError(e, e.getLineNumber(), e.getColumnNumber());
            } else {
                this.reportFatalError(wrappedExc, e.getLineNumber(), e.getColumnNumber());
            }
        }
        catch (SAXException e) {
            Exception wrappedExc = e.getException();
            if (wrappedExc == null) {
                this.reportFatalError(e);
            }
            if (wrappedExc instanceof RDFParseException) {
                throw (RDFParseException)((Object)wrappedExc);
            }
            if (wrappedExc instanceof RDFHandlerException) {
                throw (RDFHandlerException)((Object)wrappedExc);
            }
            this.reportFatalError(wrappedExc);
        }
    }

    private class TriXSAXHandler
    extends SimpleSAXAdapter {
        private Resource currentContext = null;
        private boolean parsingContext;
        private List<Value> valueList = new ArrayList<Value>(3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startTag(String tagName, Map<String, String> atts, String text) throws SAXException {
            block18: {
                try {
                    if (tagName.equals("uri")) {
                        this.valueList.add((Value)TriXParser.this.createURI(text));
                        break block18;
                    }
                    if (tagName.equals("id")) {
                        this.valueList.add((Value)TriXParser.this.createBNode(text));
                        break block18;
                    }
                    if (tagName.equals("plainLiteral")) {
                        String lang = atts.get("xml:lang");
                        this.valueList.add((Value)TriXParser.this.createLiteral(text, lang, null));
                        break block18;
                    }
                    if (tagName.equals("typedLiteral")) {
                        String datatype = atts.get("datatype");
                        if (datatype == null) {
                            TriXParser.this.reportError("datatype attribute missing for typed literal", TriXParserSettings.FAIL_ON_TRIX_MISSING_DATATYPE);
                            this.valueList.add((Value)TriXParser.this.createLiteral(text, null, null));
                        } else {
                            URI dtURI = TriXParser.this.createURI(datatype);
                            this.valueList.add((Value)TriXParser.this.createLiteral(text, null, dtURI));
                        }
                        break block18;
                    }
                    if (tagName.equals("triple")) {
                        if (!this.parsingContext) break block18;
                        try {
                            if (this.valueList.size() > 1) {
                                TriXParser.this.reportError("At most 1 resource can be specified for the context", TriXParserSettings.FAIL_ON_TRIX_INVALID_STATEMENT);
                            } else if (this.valueList.size() == 1) {
                                try {
                                    this.currentContext = (Resource)this.valueList.get(0);
                                }
                                catch (ClassCastException e) {
                                    TriXParser.this.reportError("Context identifier should be a URI or blank node", TriXParserSettings.FAIL_ON_TRIX_INVALID_STATEMENT);
                                }
                            }
                            break block18;
                        }
                        finally {
                            this.parsingContext = false;
                            this.valueList.clear();
                        }
                    }
                    if (tagName.equals("graph")) {
                        this.parsingContext = true;
                    }
                }
                catch (RDFParseException e) {
                    throw new SAXException((Exception)((Object)e));
                }
            }
        }

        public void endTag(String tagName) throws SAXException {
            try {
                if (tagName.equals("triple")) {
                    this.reportStatement();
                } else if (tagName.equals("graph")) {
                    this.currentContext = null;
                }
            }
            catch (RDFParseException e) {
                throw new SAXException((Exception)((Object)e));
            }
            catch (RDFHandlerException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportStatement() throws RDFParseException, RDFHandlerException {
            try {
                URI pred;
                Resource subj;
                if (this.valueList.size() != 3) {
                    TriXParser.this.reportError("exactly 3 values are required for a triple", TriXParserSettings.FAIL_ON_TRIX_INVALID_STATEMENT);
                    return;
                }
                try {
                    subj = (Resource)this.valueList.get(0);
                }
                catch (ClassCastException e) {
                    TriXParser.this.reportError("First value for a triple should be a URI or blank node", TriXParserSettings.FAIL_ON_TRIX_INVALID_STATEMENT);
                    this.valueList.clear();
                    return;
                }
                try {
                    pred = (URI)this.valueList.get(1);
                }
                catch (ClassCastException e) {
                    TriXParser.this.reportError("Second value for a triple should be a URI", TriXParserSettings.FAIL_ON_TRIX_INVALID_STATEMENT);
                    this.valueList.clear();
                    return;
                }
                Value obj = this.valueList.get(2);
                Statement st = TriXParser.this.createStatement(subj, pred, obj, this.currentContext);
                if (TriXParser.this.rdfHandler != null) {
                    TriXParser.this.rdfHandler.handleStatement(st);
                }
            }
            finally {
                this.valueList.clear();
            }
        }
    }
}

