/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.openrdf.sail.lucene.LuceneIndex;
import org.openrdf.sail.lucene.SearchDocument;
import org.openrdf.sail.lucene.SearchFields;

public class LuceneDocument
implements SearchDocument {
    private final Document doc;

    public LuceneDocument() {
        this(new Document());
    }

    public LuceneDocument(Document doc) {
        this.doc = doc;
    }

    public LuceneDocument(String id, String resourceId, String context) {
        this();
        this.setId(id);
        this.setResource(resourceId);
        this.setContext(context);
    }

    private void setId(String id) {
        LuceneIndex.addIDField(id, this.doc);
    }

    private void setContext(String context) {
        LuceneIndex.addContextField(context, this.doc);
    }

    private void setResource(String resourceId) {
        LuceneIndex.addResourceField(resourceId, this.doc);
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getId() {
        return this.doc.get("id");
    }

    public String getResource() {
        return this.doc.get("uri");
    }

    public String getContext() {
        return this.doc.get("context");
    }

    public Collection<String> getPropertyNames() {
        List fields = this.doc.getFields();
        ArrayList<String> names = new ArrayList<String>(fields.size());
        for (IndexableField field : fields) {
            String name = field.name();
            if (!SearchFields.isPropertyField((String)name)) continue;
            names.add(name);
        }
        return names;
    }

    public void addProperty(String name) {
    }

    public void addProperty(String name, String text) {
        LuceneIndex.addPredicateField(name, text, this.doc);
        LuceneIndex.addTextField(text, this.doc);
    }

    public boolean hasProperty(String fieldName, String value) {
        String[] fields = this.doc.getValues(fieldName);
        if (fields != null) {
            for (String field : fields) {
                if (!value.equals(field)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getProperty(String name) {
        return Arrays.asList(this.doc.getValues(name));
    }
}

