/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.lucene;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.highlight.Highlighter;
import org.openrdf.sail.lucene.DocumentScore;
import org.openrdf.sail.lucene.LuceneDocument;
import org.openrdf.sail.lucene.LuceneIndex;
import org.openrdf.sail.lucene.SearchDocument;

public class LuceneDocumentScore
implements DocumentScore {
    private final ScoreDoc scoreDoc;
    private final Highlighter highlighter;
    private final LuceneIndex index;
    private LuceneDocument fullDoc;

    public LuceneDocumentScore(ScoreDoc doc, Highlighter highlighter, LuceneIndex index) {
        this.scoreDoc = doc;
        this.highlighter = highlighter;
        this.index = index;
    }

    public SearchDocument getDocument() {
        if (this.fullDoc == null) {
            Document doc = this.highlighter != null ? this.index.getDocument(this.scoreDoc.doc, null) : this.index.getDocument(this.scoreDoc.doc, Collections.singleton("uri"));
            this.fullDoc = new LuceneDocument(doc);
        }
        return this.fullDoc;
    }

    public float getScore() {
        return this.scoreDoc.score;
    }

    public boolean isHighlighted() {
        return this.highlighter != null;
    }

    public Iterable<String> getSnippets(final String field) {
        List values = this.getDocument().getProperty(field);
        if (values == null) {
            return null;
        }
        return Iterables.transform((Iterable)values, (Function)new Function<String, String>(){

            public String apply(String text) {
                return LuceneDocumentScore.this.index.getSnippet(field, text, LuceneDocumentScore.this.highlighter);
            }
        });
    }
}

