/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.lucene;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Bits;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.sail.lucene.AbstractLuceneIndex;
import org.openrdf.sail.lucene.AbstractReaderMonitor;
import org.openrdf.sail.lucene.AbstractSearchIndex;
import org.openrdf.sail.lucene.BulkUpdater;
import org.openrdf.sail.lucene.LuceneDocument;
import org.openrdf.sail.lucene.LuceneQuery;
import org.openrdf.sail.lucene.ReaderMonitor;
import org.openrdf.sail.lucene.SearchDocument;
import org.openrdf.sail.lucene.SearchFields;
import org.openrdf.sail.lucene.SearchQuery;
import org.openrdf.sail.lucene.SimpleBulkUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndex
extends AbstractLuceneIndex {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Directory directory;
    private Analyzer analyzer;
    private Analyzer queryAnalyzer;
    private IndexWriter indexWriter;
    protected ReaderMonitor currentMonitor;

    public LuceneIndex() {
    }

    public LuceneIndex(Directory directory, Analyzer analyzer) throws IOException {
        this.directory = directory;
        this.analyzer = analyzer;
        this.postInit();
    }

    public void initialize(Properties parameters) throws Exception {
        super.initialize(parameters);
        this.directory = this.createDirectory(parameters);
        this.analyzer = this.createAnalyzer(parameters);
        this.postInit();
    }

    protected Directory createDirectory(Properties parameters) throws IOException {
        FSDirectory dir;
        if (parameters.containsKey("lucenedir")) {
            dir = FSDirectory.open((Path)Paths.get(parameters.getProperty("lucenedir"), new String[0]));
        } else if (parameters.containsKey("useramdir") && "true".equals(parameters.getProperty("useramdir"))) {
            dir = new RAMDirectory();
        } else {
            throw new IOException("No luceneIndex set, and no 'lucenedir' or 'useramdir' parameter given. ");
        }
        return dir;
    }

    protected Analyzer createAnalyzer(Properties parameters) throws Exception {
        Object analyzer = parameters.containsKey("analyzer") ? (Analyzer)Class.forName(parameters.getProperty("analyzer")).newInstance() : new StandardAnalyzer();
        return analyzer;
    }

    private void postInit() throws IOException {
        this.queryAnalyzer = new StandardAnalyzer();
        if (!DirectoryReader.indexExists((Directory)this.directory)) {
            this.logger.info("creating new Lucene index in directory {}", (Object)this.directory);
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
            indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            IndexWriter writer = new IndexWriter(this.directory, indexWriterConfig);
            writer.close();
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public IndexReader getIndexReader() throws IOException {
        return this.getIndexSearcher().getIndexReader();
    }

    public IndexSearcher getIndexSearcher() throws IOException {
        return this.getCurrentMonitor().getIndexSearcher();
    }

    public ReaderMonitor getCurrentMonitor() {
        if (this.currentMonitor == null) {
            this.currentMonitor = new ReaderMonitor(this, this.directory);
        }
        return this.currentMonitor;
    }

    public IndexWriter getIndexWriter() throws IOException {
        if (this.indexWriter == null) {
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
            this.indexWriter = new IndexWriter(this.directory, indexWriterConfig);
        }
        return this.indexWriter;
    }

    public void shutDown() throws IOException {
        if (this.currentMonitor != null) {
            this.currentMonitor.close();
            this.currentMonitor = null;
        }
        if (this.oldmonitors.size() > 0) {
            this.logger.warn("LuceneSail: On shutdown {} IndexReaders were not closed. This is due to non-closed Query Iterators, which must be closed!", (Object)this.oldmonitors.size());
        }
        for (AbstractReaderMonitor monitor : this.oldmonitors) {
            monitor.close();
        }
        this.oldmonitors.clear();
        try {
            if (this.indexWriter != null) {
                this.indexWriter.close();
            }
        }
        finally {
            this.indexWriter = null;
        }
    }

    protected SearchDocument getDocument(String id) throws IOException {
        Document document = this.getDocument(this.idTerm(id));
        return document != null ? new LuceneDocument(document) : null;
    }

    protected Iterable<? extends SearchDocument> getDocuments(String resourceId) throws IOException {
        List<Document> docs = this.getDocuments(new Term("uri", resourceId));
        return Iterables.transform(docs, (Function)new Function<Document, SearchDocument>(){

            public SearchDocument apply(Document doc) {
                return new LuceneDocument(doc);
            }
        });
    }

    protected SearchDocument newDocument(String id, String resourceId, String context) {
        return new LuceneDocument(id, resourceId, context);
    }

    protected SearchDocument copyDocument(SearchDocument doc) {
        Document document = ((LuceneDocument)doc).getDocument();
        Document newDocument = new Document();
        for (IndexableField oldField : document.getFields()) {
            newDocument.add(oldField);
        }
        return new LuceneDocument(newDocument);
    }

    protected void addDocument(SearchDocument doc) throws IOException {
        this.getIndexWriter().addDocument((Iterable)((LuceneDocument)doc).getDocument());
    }

    protected void updateDocument(SearchDocument doc) throws IOException {
        this.getIndexWriter().updateDocument(this.idTerm(doc.getId()), (Iterable)((LuceneDocument)doc).getDocument());
    }

    protected void deleteDocument(SearchDocument doc) throws IOException {
        this.getIndexWriter().deleteDocuments(new Term[]{this.idTerm(doc.getId())});
    }

    protected BulkUpdater newBulkUpdate() {
        return new SimpleBulkUpdater((AbstractSearchIndex)this);
    }

    private Term idTerm(String id) {
        return new Term("id", id);
    }

    private Document getDocument(Term idTerm) throws IOException {
        IndexReader reader = this.getIndexReader();
        List leaves = reader.leaves();
        int size = leaves.size();
        for (int i = 0; i < size; ++i) {
            LeafReader lreader = ((LeafReaderContext)leaves.get(i)).reader();
            Document document = LuceneIndex.getDocument(lreader, idTerm);
            if (document == null) continue;
            return document;
        }
        return null;
    }

    private static Document getDocument(LeafReader reader, Term term) throws IOException {
        DocsEnum docs = reader.termDocsEnum(term);
        if (docs != null) {
            int docId = docs.nextDoc();
            if (docId != Integer.MAX_VALUE) {
                if (docs.nextDoc() != Integer.MAX_VALUE) {
                    throw new IllegalStateException("Multiple Documents for term " + term.text());
                }
                return LuceneIndex.readDocument((IndexReader)reader, docId, null);
            }
            return null;
        }
        return null;
    }

    private List<Document> getDocuments(Term uriTerm) throws IOException {
        ArrayList<Document> result = new ArrayList<Document>();
        IndexReader reader = this.getIndexReader();
        List leaves = reader.leaves();
        int size = leaves.size();
        for (int i = 0; i < size; ++i) {
            LeafReader lreader = ((LeafReaderContext)leaves.get(i)).reader();
            LuceneIndex.addDocuments(lreader, uriTerm, result);
        }
        return result;
    }

    private static void addDocuments(LeafReader reader, Term term, Collection<Document> documents) throws IOException {
        DocsEnum docs = reader.termDocsEnum(term);
        if (docs != null) {
            int docId;
            while ((docId = docs.nextDoc()) != Integer.MAX_VALUE) {
                Document document = LuceneIndex.readDocument((IndexReader)reader, docId, null);
                documents.add(document);
            }
        }
    }

    public Document getDocument(Resource subject, Resource context) throws IOException {
        String resourceId = SearchFields.getResourceID((Resource)subject);
        String contextId = SearchFields.getContextID((Resource)context);
        Term idTerm = new Term("id", SearchFields.formIdString((String)resourceId, (String)contextId));
        return this.getDocument(idTerm);
    }

    public List<Document> getDocuments(Resource subject) throws IOException {
        String resourceId = SearchFields.getResourceID((Resource)subject);
        Term uriTerm = new Term("uri", resourceId);
        return this.getDocuments(uriTerm);
    }

    public static void addIDField(String id, Document document) {
        document.add((IndexableField)new StringField("id", id, Field.Store.YES));
    }

    public static void addContextField(String context, Document document) {
        if (context != null) {
            document.add((IndexableField)new StringField("context", context, Field.Store.YES));
        }
    }

    public static void addResourceField(String resourceId, Document document) {
        document.add((IndexableField)new StringField("uri", resourceId, Field.Store.YES));
    }

    public static void addPredicateField(String predicate, String text, Document document) {
        document.add((IndexableField)new TextField(predicate, text, Field.Store.YES));
    }

    public static void addTextField(String text, Document document) {
        document.add((IndexableField)new TextField("text", text, Field.Store.YES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateReaders() throws IOException {
        Collection collection = this.oldmonitors;
        synchronized (collection) {
            if (this.currentMonitor != null) {
                this.oldmonitors.add(this.currentMonitor);
            }
            this.currentMonitor = null;
            Iterator i = this.oldmonitors.iterator();
            while (i.hasNext()) {
                AbstractReaderMonitor monitor = (AbstractReaderMonitor)i.next();
                if (!monitor.closeWhenPossible()) continue;
                i.remove();
            }
            if (this.oldmonitors.isEmpty()) {
                this.logger.debug("Deleting unused files from Lucene index");
                this.getIndexWriter().deleteUnusedFiles();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logIndexStats() {
        try {
            IndexReader reader = null;
            try {
                reader = this.getIndexReader();
                int totalFields = 0;
                HashSet<String> ids = new HashSet<String>();
                int count = 0;
                for (int i = 0; i < reader.maxDoc(); ++i) {
                    String[] idArray;
                    if (LuceneIndex.isDeleted(reader, i)) continue;
                    Document doc = LuceneIndex.readDocument(reader, i, null);
                    totalFields += doc.getFields().size();
                    ++count;
                    for (String id : idArray = doc.getValues("id")) {
                        ids.add(id);
                    }
                }
                this.logger.info("Total documents in the index: " + reader.numDocs() + ", number of deletable documents in the index: " + reader.numDeletedDocs() + ", valid documents: " + count + ", total fields in all documents: " + totalFields + ", average number of fields per document: " + (double)totalFields / (double)reader.numDocs());
                this.logger.info("Distinct ids in the index: " + ids.size());
            }
            finally {
                if (this.currentMonitor != null) {
                    this.currentMonitor.closeWhenPossible();
                    this.currentMonitor = null;
                }
            }
        }
        catch (IOException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void begin() throws IOException {
    }

    public void commit() throws IOException {
        this.getIndexWriter().commit();
        this.invalidateReaders();
    }

    public void rollback() throws IOException {
        this.getIndexWriter().rollback();
    }

    protected SearchQuery parseQuery(String query, URI propertyURI) throws MalformedQueryException {
        Query q;
        try {
            q = this.getQueryParser(propertyURI).parse(query);
        }
        catch (ParseException e) {
            throw new MalformedQueryException((Throwable)e);
        }
        return new LuceneQuery(q, this);
    }

    public Document getDocument(int docId, Set<String> fieldsToLoad) {
        try {
            return LuceneIndex.readDocument(this.getIndexReader(), docId, fieldsToLoad);
        }
        catch (CorruptIndexException e) {
            this.logger.error("The index seems to be corrupted:", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            this.logger.error("Could not read from index:", (Throwable)e);
            return null;
        }
    }

    public String getSnippet(String fieldName, String text, Highlighter highlighter) {
        String snippet;
        try {
            TokenStream tokenStream = this.getAnalyzer().tokenStream(fieldName, (Reader)new StringReader(text));
            snippet = highlighter.getBestFragments(tokenStream, text, 2, "...");
        }
        catch (Exception e) {
            this.logger.error("Exception while getting snippet for field " + fieldName, (Throwable)e);
            snippet = null;
        }
        return snippet;
    }

    public TopDocs search(Resource resource, Query query) throws IOException {
        TermQuery idQuery = new TermQuery(new Term("uri", SearchFields.getResourceID((Resource)resource)));
        BooleanQuery combinedQuery = new BooleanQuery();
        combinedQuery.add((Query)idQuery, BooleanClause.Occur.MUST);
        combinedQuery.add(query, BooleanClause.Occur.MUST);
        return this.search((Query)combinedQuery);
    }

    public TopDocs search(Query query) throws IOException {
        int nDocs = this.maxDocs > 0 ? this.maxDocs : Math.max(this.getIndexReader().numDocs(), 1);
        return this.getIndexSearcher().search(query, nDocs);
    }

    private QueryParser getQueryParser(URI propertyURI) {
        if (propertyURI == null) {
            return new QueryParser("text", this.queryAnalyzer);
        }
        return new QueryParser(propertyURI.toString(), this.queryAnalyzer);
    }

    public synchronized void clearContexts(Resource ... contexts) throws IOException {
        this.logger.debug("deleting contexts: {}", (Object)Arrays.toString(contexts));
        for (Resource context : contexts) {
            String contextString = SearchFields.getContextID((Resource)context);
            Term contextTerm = new Term("context", contextString);
            this.getIndexWriter().deleteDocuments(new Term[]{contextTerm});
        }
    }

    public synchronized void clear() throws IOException {
        this.invalidateReaders();
        if (this.indexWriter != null) {
            this.indexWriter.close();
        }
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        this.indexWriter = new IndexWriter(this.directory, indexWriterConfig);
        this.indexWriter.close();
        this.indexWriter = null;
    }

    private static boolean isDeleted(IndexReader reader, int docId) {
        if (reader.hasDeletions()) {
            List leaves = reader.leaves();
            int size = leaves.size();
            for (int i = 0; i < size; ++i) {
                boolean isDeleted;
                Bits liveDocs = ((LeafReaderContext)leaves.get(i)).reader().getLiveDocs();
                if (docId >= liveDocs.length()) continue;
                boolean bl = isDeleted = !liveDocs.get(docId);
                if (!isDeleted) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static Document readDocument(IndexReader reader, int docId, Set<String> fieldsToLoad) throws IOException {
        DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor(fieldsToLoad);
        reader.document(docId, (StoredFieldVisitor)visitor);
        return visitor.getDocument();
    }

    static {
        BooleanQuery.setMaxClauseCount((int)0x100000);
    }

    static class DocumentStoredFieldVisitor
    extends StoredFieldVisitor {
        private final Set<String> fieldsToLoad;
        private final Document document = new Document();

        DocumentStoredFieldVisitor(Set<String> fieldsToLoad) {
            this.fieldsToLoad = fieldsToLoad;
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return this.fieldsToLoad == null || this.fieldsToLoad.contains(fieldInfo.name) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
        }

        public void stringField(FieldInfo fieldInfo, String value) {
            String name = fieldInfo.name;
            if ("id".equals(name)) {
                LuceneIndex.addIDField(value, this.document);
            } else if ("context".equals(name)) {
                LuceneIndex.addContextField(value, this.document);
            } else if ("uri".equals(name)) {
                LuceneIndex.addResourceField(value, this.document);
            } else if ("text".equals(name)) {
                LuceneIndex.addTextField(value, this.document);
            } else {
                LuceneIndex.addPredicateField(name, value, this.document);
            }
        }

        Document getDocument() {
            return this.document;
        }
    }
}

