/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.lucene;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.sail.lucene.DocumentScore;
import org.openrdf.sail.lucene.LuceneDocumentScore;
import org.openrdf.sail.lucene.LuceneIndex;
import org.openrdf.sail.lucene.SearchQuery;

public class LuceneQuery
implements SearchQuery {
    private final Query query;
    private final LuceneIndex index;
    private Highlighter highlighter;

    public LuceneQuery(Query q, LuceneIndex index) {
        this.query = q;
        this.index = index;
    }

    public Iterable<? extends DocumentScore> query(Resource resource) throws IOException {
        TopDocs docs = resource != null ? this.index.search(resource, this.query) : this.index.search(this.query);
        return Iterables.transform(Arrays.asList(docs.scoreDocs), (Function)new Function<ScoreDoc, DocumentScore>(){

            public DocumentScore apply(ScoreDoc doc) {
                return new LuceneDocumentScore(doc, LuceneQuery.this.highlighter, LuceneQuery.this.index);
            }
        });
    }

    public void highlight(URI property) {
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter("<B>", "</B>");
        this.highlighter = new Highlighter((Formatter)formatter, (Scorer)new QueryScorer(this.query));
    }
}

