/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.lucene.config;

import org.openrdf.sail.Sail;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailFactory;
import org.openrdf.sail.config.SailImplConfig;
import org.openrdf.sail.lucene.LuceneIndex;
import org.openrdf.sail.lucene.LuceneSail;
import org.openrdf.sail.lucene.config.AbstractLuceneSailConfig;
import org.openrdf.sail.lucene.config.LuceneSailConfig;

public class LuceneSailFactory
implements SailFactory {
    public static final String SAIL_TYPE = "openrdf:LuceneSail";

    public String getSailType() {
        return SAIL_TYPE;
    }

    public SailImplConfig getConfig() {
        return new LuceneSailConfig();
    }

    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        LuceneSail luceneSail = new LuceneSail();
        luceneSail.setParameter("index", LuceneIndex.class.getName());
        if (config instanceof AbstractLuceneSailConfig) {
            AbstractLuceneSailConfig luceneConfig = (AbstractLuceneSailConfig)config;
            luceneSail.setParameter("lucenedir", luceneConfig.getIndexDir());
        }
        return luceneSail;
    }
}

