/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory;

import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.LockingIteration;
import info.aduna.concurrent.locks.ReadPrefReadWriteLockManager;
import info.aduna.concurrent.locks.ReadWriteLockManager;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.iteration.EmptyIteration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.openrdf.IsolationLevel;
import org.openrdf.IsolationLevels;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStatistics;
import org.openrdf.sail.SailConflictException;
import org.openrdf.sail.SailException;
import org.openrdf.sail.base.BackingSailSource;
import org.openrdf.sail.base.SailDataset;
import org.openrdf.sail.base.SailSink;
import org.openrdf.sail.base.SailSource;
import org.openrdf.sail.base.SailStore;
import org.openrdf.sail.memory.MemEvaluationStatistics;
import org.openrdf.sail.memory.MemNamespaceStore;
import org.openrdf.sail.memory.model.MemResource;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemStatementIterator;
import org.openrdf.sail.memory.model.MemStatementList;
import org.openrdf.sail.memory.model.MemURI;
import org.openrdf.sail.memory.model.MemValue;
import org.openrdf.sail.memory.model.MemValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemorySailStore
implements SailStore {
    final Logger logger = LoggerFactory.getLogger(MemorySailStore.class);
    private final MemValueFactory valueFactory = new MemValueFactory();
    private final MemStatementList statements = new MemStatementList(256);
    volatile int currentSnapshot;
    private final MemNamespaceStore namespaceStore = new MemNamespaceStore();
    private final ReadWriteLockManager statementListLockManager;
    final ReentrantLock txnLockManager = new ReentrantLock();
    private volatile Thread snapshotCleanupThread;
    private final Object snapshotCleanupThreadSemaphore = new Object();

    public MemorySailStore(boolean debug) {
        this.statementListLockManager = new ReadPrefReadWriteLockManager(debug);
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void close() {
        try {
            Lock stLock = this.statementListLockManager.getWriteLock();
            try {
                this.valueFactory.clear();
                this.statements.clear();
            }
            finally {
                stLock.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public EvaluationStatistics getEvaluationStatistics() {
        return new MemEvaluationStatistics(this.valueFactory);
    }

    public SailSource getExplicitSailSource() {
        return new MemorySailSource(true);
    }

    public SailSource getInferredSailSource() {
        return new MemorySailSource(false);
    }

    Lock openStatementsReadLock() throws SailException {
        try {
            return this.statementListLockManager.getReadLock();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SailException((Throwable)e);
        }
    }

    CloseableIteration<MemStatement, SailException> createStatementIterator(Resource subj, URI pred, Value obj, Boolean explicit, int snapshot, Resource ... contexts) {
        MemStatementList l;
        MemStatementList smallestList;
        MemResource[] memContexts;
        MemResource memSubj = this.valueFactory.getMemResource(subj);
        if (subj != null && memSubj == null) {
            return new EmptyIteration();
        }
        MemURI memPred = this.valueFactory.getMemURI(pred);
        if (pred != null && memPred == null) {
            return new EmptyIteration();
        }
        MemValue memObj = this.valueFactory.getMemValue(obj);
        if (obj != null && memObj == null) {
            return new EmptyIteration();
        }
        if (contexts.length == 0) {
            memContexts = new MemResource[]{};
            smallestList = this.statements;
        } else if (contexts.length == 1 && contexts[0] != null) {
            MemResource memContext = this.valueFactory.getMemResource(contexts[0]);
            if (memContext == null) {
                return new EmptyIteration();
            }
            memContexts = new MemResource[]{memContext};
            smallestList = memContext.getContextStatementList();
        } else {
            LinkedHashSet<MemResource> contextSet = new LinkedHashSet<MemResource>(2 * contexts.length);
            for (Resource context : contexts) {
                MemResource memContext = this.valueFactory.getMemResource(context);
                if (context != null && memContext == null) continue;
                contextSet.add(memContext);
            }
            if (contextSet.isEmpty()) {
                return new EmptyIteration();
            }
            memContexts = contextSet.toArray(new MemResource[contextSet.size()]);
            smallestList = this.statements;
        }
        if (memSubj != null && (l = memSubj.getSubjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (memPred != null && (l = memPred.getPredicateStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (memObj != null && (l = memObj.getObjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        return new MemStatementIterator(smallestList, memSubj, memPred, memObj, explicit, snapshot, memContexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanSnapshots() throws InterruptedException {
        HashSet<MemResource> processedSubjects = new HashSet<MemResource>();
        HashSet<MemURI> processedPredicates = new HashSet<MemURI>();
        HashSet<MemValue> processedObjects = new HashSet<MemValue>();
        HashSet<MemResource> processedContexts = new HashSet<MemResource>();
        Lock stLock = this.statementListLockManager.getWriteLock();
        try {
            for (int i = this.statements.size() - 1; i >= 0; --i) {
                MemStatement st = this.statements.get(i);
                if (st.getTillSnapshot() <= this.currentSnapshot) {
                    MemResource context;
                    MemValue obj;
                    MemURI pred;
                    MemResource subj = st.getSubject();
                    if (processedSubjects.add(subj)) {
                        subj.cleanSnapshotsFromSubjectStatements(this.currentSnapshot);
                    }
                    if (processedPredicates.add(pred = st.getPredicate())) {
                        pred.cleanSnapshotsFromPredicateStatements(this.currentSnapshot);
                    }
                    if (processedObjects.add(obj = st.getObject())) {
                        obj.cleanSnapshotsFromObjectStatements(this.currentSnapshot);
                    }
                    if ((context = st.getContext()) != null && processedContexts.add(context)) {
                        context.cleanSnapshotsFromContextStatements(this.currentSnapshot);
                    }
                    this.statements.remove(i);
                    continue;
                }
                st.setSinceSnapshot(1);
            }
            this.currentSnapshot = 1;
        }
        finally {
            stLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleSnapshotCleanup() {
        Object object = this.snapshotCleanupThreadSemaphore;
        synchronized (object) {
            if (this.snapshotCleanupThread == null || !this.snapshotCleanupThread.isAlive()) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MemorySailStore.this.cleanSnapshots();
                        }
                        catch (InterruptedException e) {
                            MemorySailStore.this.logger.warn("snapshot cleanup interrupted");
                        }
                    }
                };
                this.snapshotCleanupThread = new Thread(runnable, "MemoryStore snapshot cleanup");
                this.snapshotCleanupThread.setDaemon(true);
                this.snapshotCleanupThread.start();
            }
        }
    }

    private final class MemorySailDataset
    implements SailDataset {
        private final boolean explicit;
        private final int snapshot;
        private final Lock lock;

        public MemorySailDataset(boolean explicit) throws SailException {
            this.explicit = explicit;
            this.snapshot = -1;
            this.lock = null;
        }

        public MemorySailDataset(boolean explicit, int snapshot) throws SailException {
            this.explicit = explicit;
            this.snapshot = snapshot;
            this.lock = MemorySailStore.this.openStatementsReadLock();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.explicit) {
                sb.append("explicit ");
            } else {
                sb.append("inferred ");
            }
            if (this.snapshot >= 0) {
                sb.append("snapshot ").append(this.snapshot);
            } else {
                sb.append(super.toString());
            }
            return sb.toString();
        }

        public void close() {
            if (this.lock != null) {
                this.lock.release();
            }
        }

        public String getNamespace(String prefix) throws SailException {
            return MemorySailStore.this.namespaceStore.getNamespace(prefix);
        }

        public CloseableIteration<? extends Namespace, SailException> getNamespaces() {
            return new CloseableIteratorIteration(MemorySailStore.this.namespaceStore.iterator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
            ArrayList<MemResource> contextIDs = new ArrayList<MemResource>(32);
            Lock stLock = MemorySailStore.this.openStatementsReadLock();
            try {
                MemValueFactory memValueFactory = MemorySailStore.this.valueFactory;
                synchronized (memValueFactory) {
                    int snapshot = this.getCurrentSnapshot();
                    for (MemResource memResource : MemorySailStore.this.valueFactory.getMemURIs()) {
                        if (!this.isContextResource(memResource, snapshot)) continue;
                        contextIDs.add(memResource);
                    }
                    for (MemResource memResource : MemorySailStore.this.valueFactory.getMemBNodes()) {
                        if (!this.isContextResource(memResource, snapshot)) continue;
                        contextIDs.add(memResource);
                    }
                }
            }
            finally {
                stLock.release();
            }
            return new CloseableIteratorIteration(contextIDs.iterator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
            boolean releaseLock = true;
            Lock stLock = MemorySailStore.this.openStatementsReadLock();
            try {
                LockingIteration ret = MemorySailStore.this.createStatementIterator(subj, pred, obj, this.explicit, this.getCurrentSnapshot(), contexts);
                ret = new LockingIteration(stLock, ret);
                releaseLock = false;
                LockingIteration lockingIteration = ret;
                return lockingIteration;
            }
            finally {
                if (releaseLock) {
                    stLock.release();
                }
            }
        }

        private int getCurrentSnapshot() {
            if (this.snapshot >= 0) {
                return this.snapshot;
            }
            return MemorySailStore.this.currentSnapshot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isContextResource(MemResource memResource, int snapshot) throws SailException {
            MemStatementList contextStatements = memResource.getContextStatementList();
            if (contextStatements.size() == 0) {
                return false;
            }
            MemStatementIterator iter = new MemStatementIterator(contextStatements, null, null, null, null, snapshot, new MemResource[0]);
            try {
                boolean bl = iter.hasNext();
                return bl;
            }
            finally {
                iter.close();
            }
        }
    }

    private final class MemorySailSink
    implements SailSink {
        private boolean explicit;
        private final int serializable;
        private final Lock txnStLock;
        private int nextSnapshot;
        private Set<StatementPattern> observations;
        private boolean txnLock;

        public MemorySailSink(boolean explicit, boolean serializable) throws SailException {
            this.explicit = explicit;
            this.serializable = serializable ? MemorySailStore.this.currentSnapshot : Integer.MAX_VALUE;
            this.txnStLock = MemorySailStore.this.openStatementsReadLock();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.explicit) {
                sb.append("explicit ");
            } else {
                sb.append("inferred ");
            }
            if (this.txnLock) {
                sb.append("snapshot ").append(this.nextSnapshot);
            } else {
                sb.append(super.toString());
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void prepare() throws SailException {
            this.acquireExclusiveTransactionLock();
            if (this.observations != null) {
                for (StatementPattern p : this.observations) {
                    Resource subj = (Resource)p.getSubjectVar().getValue();
                    URI pred = (URI)p.getPredicateVar().getValue();
                    Value obj = p.getObjectVar().getValue();
                    Var ctxVar = p.getContextVar();
                    Resource[] contexts = ctxVar == null ? new Resource[]{} : new Resource[]{(Resource)ctxVar.getValue()};
                    CloseableIteration<MemStatement, SailException> iter = MemorySailStore.this.createStatementIterator(subj, pred, obj, null, -1, contexts);
                    try {
                        while (iter.hasNext()) {
                            MemStatement st = (MemStatement)((Object)iter.next());
                            int since = st.getSinceSnapshot();
                            int till = st.getTillSnapshot();
                            if ((this.serializable >= since || since >= this.nextSnapshot) && (this.serializable >= till || till >= this.nextSnapshot)) continue;
                            throw new SailConflictException("Observed State has Changed");
                        }
                    }
                    finally {
                        iter.close();
                    }
                }
            }
        }

        public void flush() throws SailException {
            if (this.txnLock) {
                MemorySailStore.this.currentSnapshot = Math.max(MemorySailStore.this.currentSnapshot, this.nextSnapshot);
                MemorySailStore.this.scheduleSnapshotCleanup();
            }
        }

        public void close() {
            if (this.txnLock) {
                MemorySailStore.this.txnLockManager.unlock();
                this.txnLock = false;
            }
            if (this.txnStLock != null) {
                this.txnStLock.release();
            }
        }

        public synchronized void setNamespace(String prefix, String name) throws SailException {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.namespaceStore.setNamespace(prefix, name);
        }

        public void removeNamespace(String prefix) throws SailException {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.namespaceStore.removeNamespace(prefix);
        }

        public void clearNamespaces() throws SailException {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.namespaceStore.clear();
        }

        public void observe(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
            if (this.observations == null) {
                this.observations = new HashSet<StatementPattern>();
            }
            if (contexts == null) {
                this.observations.add(new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj), new Var("g", null)));
            } else if (contexts.length == 0) {
                this.observations.add(new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj)));
            } else {
                for (Resource ctx : contexts) {
                    this.observations.add(new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj), new Var("g", (Value)ctx)));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear(Resource ... contexts) throws SailException {
            this.acquireExclusiveTransactionLock();
            CloseableIteration<MemStatement, SailException> iter = MemorySailStore.this.createStatementIterator(null, null, null, this.explicit, this.nextSnapshot, contexts);
            try {
                while (iter.hasNext()) {
                    MemStatement st = (MemStatement)((Object)iter.next());
                    st.setTillSnapshot(this.nextSnapshot);
                }
            }
            finally {
                iter.close();
            }
        }

        public synchronized void approve(Resource subj, URI pred, Value obj, Resource ctx) throws SailException {
            this.acquireExclusiveTransactionLock();
            this.addStatement(subj, pred, obj, ctx, this.explicit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void deprecate(Resource subj, URI pred, Value obj, Resource ctx) throws SailException {
            this.acquireExclusiveTransactionLock();
            CloseableIteration<MemStatement, SailException> iter = MemorySailStore.this.createStatementIterator(subj, pred, obj, this.explicit, this.nextSnapshot, ctx);
            try {
                while (iter.hasNext()) {
                    MemStatement st = (MemStatement)((Object)iter.next());
                    st.setTillSnapshot(this.nextSnapshot);
                }
            }
            finally {
                iter.close();
            }
        }

        private void acquireExclusiveTransactionLock() throws SailException {
            if (!this.txnLock) {
                MemorySailStore.this.txnLockManager.lock();
                this.nextSnapshot = MemorySailStore.this.currentSnapshot + 1;
                this.txnLock = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MemStatement addStatement(Resource subj, URI pred, Value obj, Resource context, boolean explicit) throws SailException {
            MemResource memContext;
            MemValue memObj;
            MemURI memPred;
            MemResource memSubj;
            block6: {
                memSubj = MemorySailStore.this.valueFactory.getOrCreateMemResource(subj);
                memPred = MemorySailStore.this.valueFactory.getOrCreateMemURI(pred);
                memObj = MemorySailStore.this.valueFactory.getOrCreateMemValue(obj);
                MemResource memResource = memContext = context == null ? null : MemorySailStore.this.valueFactory.getOrCreateMemResource(context);
                if (memSubj.hasStatements() && memPred.hasStatements() && memObj.hasStatements() && (memContext == null || memContext.hasStatements())) {
                    CloseableIteration<MemStatement, SailException> stIter = MemorySailStore.this.createStatementIterator(memSubj, memPred, memObj, null, 0x7FFFFFFE, memContext);
                    try {
                        if (!stIter.hasNext()) break block6;
                        MemStatement st = (MemStatement)((Object)stIter.next());
                        if (!st.isExplicit() && explicit) {
                            st.setTillSnapshot(this.nextSnapshot);
                            break block6;
                        }
                        if (!st.isInSnapshot(this.nextSnapshot)) {
                            st.setSinceSnapshot(this.nextSnapshot);
                            break block6;
                        }
                        MemStatement memStatement = null;
                        return memStatement;
                    }
                    finally {
                        stIter.close();
                    }
                }
            }
            MemStatement st = new MemStatement(memSubj, memPred, memObj, memContext, explicit, this.nextSnapshot);
            MemorySailStore.this.statements.add(st);
            st.addToComponentLists();
            return st;
        }
    }

    private final class MemorySailSource
    extends BackingSailSource {
        private final boolean explicit;

        public MemorySailSource(boolean explicit) {
            this.explicit = explicit;
        }

        public SailSink sink(IsolationLevel level) throws SailException {
            return new MemorySailSink(this.explicit, level.isCompatibleWith((IsolationLevel)IsolationLevels.SERIALIZABLE));
        }

        public MemorySailDataset dataset(IsolationLevel level) throws SailException {
            if (level.isCompatibleWith((IsolationLevel)IsolationLevels.SNAPSHOT_READ)) {
                return new MemorySailDataset(this.explicit, MemorySailStore.this.currentSnapshot);
            }
            return new MemorySailDataset(this.explicit);
        }
    }
}

