/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.model;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import info.aduna.iterator.CloseableIterationIterator;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.openrdf.model.Model;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.AbstractModel;
import org.openrdf.model.impl.FilteredModel;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.model.util.ModelException;
import org.openrdf.sail.AdvancedSailConnection;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.util.NonSerializables;

public class SailModel
extends AbstractModel {
    private static final long serialVersionUID = -2104886971549374410L;
    private transient SailConnection conn;
    private UUID connKey;
    private boolean includeInferred;

    public SailModel(SailConnection conn, boolean includeInferred) {
        this.conn = conn;
        this.includeInferred = includeInferred;
    }

    public void setConnection(SailConnection conn) {
        this.conn = conn;
    }

    public Set<Namespace> getNamespaces() {
        Set namespaces;
        try {
            CloseableIteration iter = this.conn.getNamespaces();
            try {
                namespaces = Iterations.asSet((Iteration)this.conn.getNamespaces());
            }
            finally {
                iter.close();
            }
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
        return namespaces;
    }

    public Namespace getNamespace(String prefix) {
        try {
            String name = this.conn.getNamespace(prefix);
            return name != null ? new NamespaceImpl(prefix, name) : null;
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
    }

    public Namespace setNamespace(String prefix, String name) {
        try {
            this.conn.setNamespace(prefix, name);
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
        return new NamespaceImpl(prefix, name);
    }

    public void setNamespace(Namespace namespace) {
        try {
            this.conn.setNamespace(namespace.getPrefix(), namespace.getName());
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
    }

    public Namespace removeNamespace(String prefix) {
        Namespace namespace = this.getNamespace(prefix);
        if (namespace != null) {
            try {
                this.conn.removeNamespace(prefix);
            }
            catch (SailException e) {
                throw new ModelException((Throwable)e);
            }
        }
        return namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Resource subj, URI pred, Value obj, Resource ... contexts) {
        boolean bl;
        if (this.conn instanceof AdvancedSailConnection) {
            return ((AdvancedSailConnection)this.conn).hasStatement(subj, pred, obj, this.includeInferred, contexts);
        }
        CloseableIteration iter = this.conn.getStatements(subj, pred, obj, this.includeInferred, contexts);
        try {
            bl = iter.hasNext();
        }
        catch (Throwable throwable) {
            try {
                iter.close();
                throw throwable;
            }
            catch (SailException e) {
                throw new ModelException((Throwable)e);
            }
        }
        iter.close();
        return bl;
    }

    public boolean add(Resource subj, URI pred, Value obj, Resource ... contexts) {
        if (subj == null || pred == null || obj == null) {
            throw new UnsupportedOperationException("Incomplete statement");
        }
        boolean exists = this.contains(subj, pred, obj, contexts);
        if (!exists) {
            try {
                this.conn.addStatement(subj, pred, obj, contexts);
            }
            catch (SailException e) {
                throw new ModelException((Throwable)e);
            }
        }
        return !exists;
    }

    public boolean remove(Resource subj, URI pred, Value obj, Resource ... contexts) {
        boolean exists = this.contains(subj, pred, obj, contexts);
        if (exists) {
            try {
                this.conn.removeStatements(subj, pred, obj, contexts);
            }
            catch (SailException e) {
                throw new ModelException((Throwable)e);
            }
        }
        return exists;
    }

    public boolean clear(Resource ... contexts) {
        boolean exists = this.contains(null, null, null, contexts);
        if (exists) {
            try {
                this.conn.clear(contexts);
            }
            catch (SailException e) {
                throw new ModelException((Throwable)e);
            }
        }
        return exists;
    }

    public Model filter(Resource subj, URI pred, Value obj, Resource ... contexts) {
        return new FilteredModel(this, subj, pred, obj, contexts){
            private static final long serialVersionUID = -3834026632361358191L;

            public Iterator<Statement> iterator() {
                return SailModel.this.iterator(this.subj, this.pred, this.obj, this.contexts);
            }

            protected void removeFilteredTermIteration(Iterator<Statement> iter, Resource subj, URI pred, Value obj, Resource ... contexts) {
                SailModel.this.removeTermIteration(iter, subj, pred, obj, contexts);
            }
        };
    }

    public void removeTermIteration(Iterator<Statement> iter, Resource subj, URI pred, Value obj, Resource ... contexts) {
        try {
            this.conn.removeStatements(subj, pred, obj, contexts);
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
    }

    public Iterator<Statement> iterator() {
        return this.iterator(null, null, null, new Resource[0]);
    }

    private Iterator<Statement> iterator(Resource subj, URI pred, Value obj, Resource ... contexts) {
        try {
            CloseableIteration iter = this.conn.getStatements(subj, pred, obj, this.includeInferred, contexts);
            return new CloseableIterationIterator((Iteration)new ExceptionConvertingIteration<Statement, ModelException>((Iteration)iter){
                private Statement last;

                public Statement next() {
                    this.last = (Statement)super.next();
                    return this.last;
                }

                public void remove() {
                    if (this.last == null) {
                        throw new IllegalStateException("next() not yet called");
                    }
                    SailModel.this.remove(this.last);
                    this.last = null;
                }

                protected ModelException convert(Exception e) {
                    throw new ModelException((Throwable)e);
                }
            });
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
    }

    protected void closeIterator(Iterator<?> iter) {
        if (iter instanceof Closeable) {
            try {
                ((Closeable)((Object)iter)).close();
            }
            catch (IOException ioe) {
                throw new ModelException((Throwable)ioe);
            }
        } else {
            super.closeIterator(iter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        long lsize;
        if (!this.includeInferred) {
            try {
                lsize = this.conn.size(new Resource[0]);
            }
            catch (SailException e) {
                throw new ModelException((Throwable)e);
            }
        }
        lsize = 0L;
        Iterator<Statement> iter = this.iterator();
        try {
            while (iter.hasNext()) {
                ++lsize;
                iter.next();
            }
        }
        finally {
            this.closeIterator(iter);
        }
        return lsize < Integer.MAX_VALUE ? (int)lsize : Integer.MAX_VALUE;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.connKey = NonSerializables.register((Object)this.conn);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.conn = (SailConnection)SailConnection.class.cast(NonSerializables.get((UUID)this.connKey));
    }
}

