/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensaml.saml.ext.saml2mdui.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.opensaml.saml.common.AbstractSAMLObjectBuilder;
import org.opensaml.saml.common.xml.SAMLConstants;
import org.opensaml.saml.ext.saml2mdui.Description;

/**
 * Builder of {@link Description} objects.
 */
public class DescriptionBuilder extends AbstractSAMLObjectBuilder<Description> {
    /**
     * Constructor.
     */
    public DescriptionBuilder() {

    }

    /** {@inheritDoc} */
    @Override
    @Nonnull public Description buildObject() {
        return buildObject(SAMLConstants.SAML20MDUI_NS, Description.DEFAULT_ELEMENT_LOCAL_NAME,
                SAMLConstants.SAML20MDUI_PREFIX);
    }

    /** {@inheritDoc} */
    @Override
    @Nonnull public Description buildObject(@Nullable final String namespaceURI, @Nonnull final String localName,
            @Nullable final String namespacePrefix) {
        return new DescriptionImpl(namespaceURI, localName, namespacePrefix);
    }

}