/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.soap11.encoder.http.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpPost;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.soap.client.soap11.encoder.http.impl.HttpClientRequestSOAP11Encoder;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wsaddressing.Action;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HttpClientRequestSOAP11EncoderTest
extends XMLObjectBaseTestCase {
    private HttpClientRequestSOAP11Encoder encoder;
    private MessageContext messageContext;
    private HttpPost request;

    @BeforeMethod
    public void setUp() {
        this.request = new HttpPost("http://example.org/soap/receiver");
        this.messageContext = new MessageContext();
        this.encoder = new HttpClientRequestSOAP11Encoder();
        this.encoder.setMessageContext(this.messageContext);
        this.encoder.setHttpRequest((HttpRequest)this.request);
    }

    @Test
    public void testBasic() throws ComponentInitializationException, MessageEncodingException {
        SimpleXMLObject sxo = (SimpleXMLObject)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME);
        this.messageContext.setMessage((Object)sxo);
        this.encoder.initialize();
        this.encoder.prepareContext();
        SOAP11Context soapContext = (SOAP11Context)this.messageContext.getSubcontext(SOAP11Context.class);
        Assert.assertNotNull((Object)soapContext);
        Envelope envelope = soapContext.getEnvelope();
        Assert.assertNotNull((Object)envelope);
        this.encoder.encode();
        Assert.assertNotNull((Object)this.request.getEntity());
        Assert.assertTrue((boolean)this.request.getEntity().getContentType().getValue().startsWith("text/xml;"), (String)"Unexpected content type");
        Assert.assertEquals((String)this.request.getEntity().getContentType().getElements()[0].getParameterByName("charset").getValue(), (String)"UTF-8", (String)"Unexpected character encoding");
        Assert.assertEquals((String)this.request.getFirstHeader("SOAPAction").getValue(), (String)"");
    }

    @Test
    public void testAction() throws ComponentInitializationException, MessageEncodingException {
        SimpleXMLObject sxo = (SimpleXMLObject)this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME);
        this.messageContext.setMessage((Object)sxo);
        this.encoder.initialize();
        this.encoder.prepareContext();
        SOAP11Context soapContext = (SOAP11Context)this.messageContext.getSubcontext(SOAP11Context.class);
        Assert.assertNotNull((Object)soapContext);
        Envelope envelope = soapContext.getEnvelope();
        Assert.assertNotNull((Object)envelope);
        Action action = (Action)this.buildXMLObject(Action.ELEMENT_NAME);
        action.setURI("urn:test:action:foo");
        if (envelope.getHeader() == null) {
            envelope.setHeader((Header)this.buildXMLObject(Header.DEFAULT_ELEMENT_NAME));
        }
        envelope.getHeader().getUnknownXMLObjects().add(action);
        this.encoder.encode();
        Assert.assertNotNull((Object)this.request.getEntity());
        Assert.assertTrue((boolean)this.request.getEntity().getContentType().getValue().startsWith("text/xml;"), (String)"Unexpected content type");
        Assert.assertEquals((String)this.request.getEntity().getContentType().getElements()[0].getParameterByName("charset").getValue(), (String)"UTF-8", (String)"Unexpected character encoding");
        Assert.assertEquals((String)this.request.getFirstHeader("SOAPAction").getValue(), (String)"urn:test:action:foo");
    }
}

