/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.decoder.http.impl;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.decoder.http.impl.HTTPSOAP11Decoder;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HTTPSOAP11DecoderTest
extends XMLObjectBaseTestCase {
    private HTTPSOAP11Decoder decoder;
    private MockHttpServletRequest httpRequest;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.httpRequest = new MockHttpServletRequest();
        this.httpRequest.setMethod("POST");
        this.httpRequest.setContentType("text/xml; charset=utf-8");
        this.decoder = new HTTPSOAP11Decoder();
        this.decoder.setParserPool(parserPool);
        this.decoder.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            public HttpServletRequest get() {
                return HTTPSOAP11DecoderTest.this.httpRequest;
            }
        });
    }

    @Test
    public void testDecodeToEnvelope() throws ComponentInitializationException, MessageDecodingException, IOException {
        this.httpRequest.setContent(this.getServletRequestContent("/org/opensaml/soap/soap11/SOAPNoHeaders.xml"));
        this.decoder.setBodyHandler((MessageHandler)new TestEnvelopeBodyHandler());
        this.decoder.initialize();
        this.decoder.decode();
        MessageContext msgContext = this.decoder.getMessageContext();
        Object msg = msgContext.getMessage();
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((boolean)(msg instanceof Envelope));
    }

    @Test
    public void testDecodeToPayload() throws ComponentInitializationException, MessageDecodingException, IOException {
        this.httpRequest.setContent(this.getServletRequestContent("/org/opensaml/soap/soap11/SOAPNoHeaders.xml"));
        this.decoder.setBodyHandler((MessageHandler)new TestPayloadBodyHandler());
        this.decoder.initialize();
        this.decoder.decode();
        MessageContext msgContext = this.decoder.getMessageContext();
        Object msg = msgContext.getMessage();
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((boolean)(msg instanceof XSAny));
    }

    @Test(expectedExceptions={MessageDecodingException.class})
    public void testmissingContentType() throws ComponentInitializationException, MessageDecodingException, IOException {
        this.httpRequest.setContent(this.getServletRequestContent("/org/opensaml/soap/soap11/SOAPNoHeaders.xml"));
        this.httpRequest.setContentType(null);
        this.decoder.setBodyHandler((MessageHandler)new TestEnvelopeBodyHandler());
        this.decoder.initialize();
        this.decoder.decode();
    }

    @Test(expectedExceptions={MessageDecodingException.class})
    public void testInvalidContentType() throws ComponentInitializationException, MessageDecodingException, IOException {
        this.httpRequest.setContent(this.getServletRequestContent("/org/opensaml/soap/soap11/SOAPNoHeaders.xml"));
        this.httpRequest.setContentType("application/x-www-form-urlencoded");
        this.decoder.setBodyHandler((MessageHandler)new TestEnvelopeBodyHandler());
        this.decoder.initialize();
        this.decoder.decode();
    }

    private byte[] getServletRequestContent(String resourceName) throws IOException {
        return Resources.toByteArray((URL)((Object)((Object)this)).getClass().getResource(resourceName));
    }

    public class TestPayloadBodyHandler
    extends AbstractMessageHandler {
        protected void doInvoke(MessageContext msgContext) throws MessageHandlerException {
            Envelope env = ((SOAP11Context)msgContext.getSubcontext(SOAP11Context.class)).getEnvelope();
            msgContext.setMessage(env.getBody().getUnknownXMLObjects().get(0));
        }
    }

    public class TestEnvelopeBodyHandler
    extends AbstractMessageHandler {
        protected void doInvoke(MessageContext msgContext) throws MessageHandlerException {
            Envelope env = ((SOAP11Context)msgContext.getSubcontext(SOAP11Context.class)).getEnvelope();
            msgContext.setMessage((Object)env);
        }
    }
}

