/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wsaddressing.messaging.impl;

import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.testing.SOAPMessagingBaseTestCase;
import org.opensaml.soap.wsaddressing.RelatesTo;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;
import org.opensaml.soap.wsaddressing.messaging.impl.AddRelatesToHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddRelatesToHandlerTest
extends SOAPMessagingBaseTestCase {
    private AddRelatesToHandler handler;

    @BeforeMethod
    protected void setUp() throws ComponentInitializationException {
        this.handler = new AddRelatesToHandler();
    }

    @Test
    public void testNoInput() throws ComponentInitializationException, MessageHandlerException {
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertTrue((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)RelatesTo.ELEMENT_NAME).isEmpty());
    }

    @Test
    public void testContext() throws ComponentInitializationException, MessageHandlerException {
        ((WSAddressingContext)this.getMessageContext().getSubcontext(WSAddressingContext.class, true)).setRelatesToURI("urn:test:abc123");
        ((WSAddressingContext)this.getMessageContext().getSubcontext(WSAddressingContext.class, true)).setRelatesToRelationshipType("http://www.w3.org/2005/08/addressing/reply");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)RelatesTo.ELEMENT_NAME).isEmpty());
        RelatesTo relatesTo = (RelatesTo)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)RelatesTo.ELEMENT_NAME).get(0);
        Assert.assertEquals((String)relatesTo.getURI(), (String)"urn:test:abc123");
        Assert.assertEquals((String)relatesTo.getRelationshipType(), (String)"http://www.w3.org/2005/08/addressing/reply");
    }

    @Test
    public void testLookup() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setRelatesToURILookup((ContextDataLookupFunction)new ContextDataLookupFunction<MessageContext, String>(){

            @Nullable
            public String apply(@Nullable MessageContext input) {
                return "urn:test:def456";
            }
        });
        this.handler.setRelationshipType("urn:test:foo");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)RelatesTo.ELEMENT_NAME).isEmpty());
        RelatesTo relatesTo = (RelatesTo)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)RelatesTo.ELEMENT_NAME).get(0);
        Assert.assertEquals((String)relatesTo.getURI(), (String)"urn:test:def456");
        Assert.assertEquals((String)relatesTo.getRelationshipType(), (String)"urn:test:foo");
    }
}

