/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.impl;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.soap.testing.WSBaseTestCase;
import org.opensaml.soap.wssecurity.BinarySecurityToken;
import org.opensaml.soap.wssecurity.Created;
import org.opensaml.soap.wssecurity.Embedded;
import org.opensaml.soap.wssecurity.EncryptedHeader;
import org.opensaml.soap.wssecurity.Expires;
import org.opensaml.soap.wssecurity.Iteration;
import org.opensaml.soap.wssecurity.Nonce;
import org.opensaml.soap.wssecurity.Password;
import org.opensaml.soap.wssecurity.Reference;
import org.opensaml.soap.wssecurity.Salt;
import org.opensaml.soap.wssecurity.Timestamp;
import org.opensaml.soap.wssecurity.Username;
import org.opensaml.soap.wssecurity.UsernameToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public class WSSecurityObjectsTestCase
extends WSBaseTestCase {
    public Logger log = LoggerFactory.getLogger(WSSecurityObjectsTestCase.class);

    protected void unmarshallAndMarshall(String filename) throws Exception {
    }

    @Test
    public void testBinarySecurityToken() throws Exception {
        BinarySecurityToken token = (BinarySecurityToken)this.buildXMLObject(BinarySecurityToken.ELEMENT_NAME);
        token.setWSUId("BinarySecurityToken-" + System.currentTimeMillis());
        token.setValue("Base64Encoded_X509_CERTIFICATE...");
        token.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        Assert.assertEquals((String)token.getEncodingType(), (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        this.marshallAndUnmarshall(token);
    }

    @Test
    public void testCreated() throws Exception {
    }

    @Test
    public void testEmbedded() throws Exception {
        Embedded embedded = (Embedded)this.buildXMLObject(Embedded.ELEMENT_NAME);
        UsernameToken usernameToken = this.createUsernameToken("EmbeddedUT", "EmbeddedUT");
        embedded.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        embedded.getUnknownXMLObjects().add(usernameToken);
        this.marshallAndUnmarshall(embedded);
    }

    @Test
    public void testEncryptedHeader() throws Exception {
        EncryptedHeader eh = (EncryptedHeader)this.buildXMLObject(EncryptedHeader.ELEMENT_NAME);
        eh.setWSUId("abc123");
        eh.setSOAP11MustUnderstand(Boolean.valueOf(true));
        eh.setSOAP11Actor("urn:test:soap11actor");
        eh.setSOAP12MustUnderstand(Boolean.valueOf(true));
        eh.setSOAP12Role("urn:test:soap12role");
        eh.setSOAP12Relay(Boolean.valueOf(true));
        this.marshallAndUnmarshall(eh);
    }

    @Test
    public void testExpires() throws Exception {
    }

    @Test
    public void testIteration() throws Exception {
        Iteration iteration = (Iteration)this.buildXMLObject(Iteration.ELEMENT_NAME);
        iteration.setValue(Integer.valueOf(1000));
        this.marshallAndUnmarshall(iteration);
    }

    @Test
    public void testKeyIdentifier() throws Exception {
    }

    @Test
    public void testNonce() throws Exception {
        Nonce nonce = (Nonce)this.buildXMLObject(Nonce.ELEMENT_NAME);
        nonce.setValue("Base64EncodedValue...");
        this.marshallAndUnmarshall(nonce);
    }

    @Test
    public void testPassword() throws Exception {
        Password password = (Password)this.buildXMLObject(Password.ELEMENT_NAME);
        password.setValue("test");
        Assert.assertEquals((String)password.getType(), (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd#PasswordText");
        this.marshallAndUnmarshall(password);
    }

    @Test
    public void testReference() throws Exception {
        Reference reference = (Reference)this.buildXMLObject(Reference.ELEMENT_NAME);
        reference.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        reference.setURI("#UsernameToken-0000001");
        this.marshallAndUnmarshall(reference);
    }

    @Test
    public void testSalt() throws Exception {
        Salt salt = (Salt)this.buildXMLObject(Salt.ELEMENT_NAME);
        salt.setValue("Base64Encoded_Salt_VALUE...");
        this.marshallAndUnmarshall(salt);
    }

    @Test
    public void testSecurity() throws Exception {
    }

    @Test
    public void testSecurityTokenReference() throws Exception {
    }

    @Test
    public void testSignatureConfirmation() throws Exception {
    }

    @Test
    public void testTimestamp() throws Exception {
        Timestamp timestamp = (Timestamp)this.buildXMLObject(Timestamp.ELEMENT_NAME);
        Created created = (Created)this.buildXMLObject(Created.ELEMENT_NAME);
        Instant now = Instant.now();
        created.setDateTime(now);
        timestamp.setCreated(created);
        Expires expires = (Expires)this.buildXMLObject(Expires.ELEMENT_NAME);
        expires.setDateTime(now.plus(10L, ChronoUnit.MINUTES));
        timestamp.setExpires(expires);
        timestamp.setWSUId("Timestamp-" + System.currentTimeMillis());
        this.marshallAndUnmarshall(timestamp);
    }

    @Test
    public void testTransformationParameters() throws Exception {
    }

    @Test
    public void testUsername() throws Exception {
        Username username = (Username)this.buildXMLObject(Username.ELEMENT_NAME);
        username.setValue("test");
        this.marshallAndUnmarshall(username);
    }

    @Test
    public void testUsernameToken() throws Exception {
        String refId = "UsernameToken-007";
        String refDateTimeStr = "2007-12-19T09:53:08.335Z";
        UsernameToken usernameToken = this.createUsernameToken("test", "test");
        usernameToken.setWSUId(refId);
        Instant refDateTime = Instant.parse(refDateTimeStr);
        Created usernameCreated = (Created)usernameToken.getUnknownXMLObjects(Created.ELEMENT_NAME).get(0);
        usernameCreated.setDateTime(refDateTime);
        Password password = (Password)usernameToken.getUnknownXMLObjects(Password.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)password);
        Assert.assertEquals((String)password.getType(), (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd#PasswordText");
        List children = usernameToken.getOrderedChildren();
        Assert.assertEquals((int)children.size(), (int)3);
        this.marshallAndUnmarshall(usernameToken);
        Element refElement = this.parseXMLDocument("/org/opensaml/soap/wssecurity/impl/UsernameToken.xml").getDocumentElement();
        Marshaller marshaller = this.getMarshaller((XMLObject)usernameToken);
        Element element = marshaller.marshall((XMLObject)usernameToken);
        Diff diff = DiffBuilder.compare((Object)refElement).withTest((Object)element).checkForIdentical().ignoreWhitespace().build();
        Assert.assertFalse((boolean)diff.hasDifferences(), (String)diff.toString());
        UsernameToken ut = (UsernameToken)this.unmarshallElement("/org/opensaml/soap/wssecurity/impl/UsernameToken.xml");
        Assert.assertEquals((String)ut.getUsername().getValue(), (String)"test");
        Password utPassword = (Password)ut.getUnknownXMLObjects(Password.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)utPassword);
        Assert.assertEquals((String)utPassword.getValue(), (String)"test");
        Created utCreated = (Created)ut.getUnknownXMLObjects(Created.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)utCreated);
        Instant created = utCreated.getDateTime();
        System.out.println(created);
    }

    protected UsernameToken createUsernameToken(String user, String pass) throws Exception {
        UsernameToken usernameToken = (UsernameToken)this.buildXMLObject(UsernameToken.ELEMENT_NAME);
        Username username = (Username)this.buildXMLObject(Username.ELEMENT_NAME);
        username.setValue(user);
        Password password = (Password)this.buildXMLObject(Password.ELEMENT_NAME);
        password.setValue(pass);
        Created created = (Created)this.buildXMLObject(Created.ELEMENT_NAME);
        created.setDateTime(Instant.now());
        String id = "UsernameToken-" + System.currentTimeMillis();
        usernameToken.setWSUId(id);
        usernameToken.setUsername(username);
        usernameToken.getUnknownXMLObjects().add(password);
        usernameToken.getUnknownXMLObjects().add(created);
        return usernameToken;
    }
}

