/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Operator;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class CommonTermsQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Double cutoffFrequency;
    @Nullable
    private final Operator highFreqOperator;
    @Nullable
    private final Operator lowFreqOperator;
    @Nullable
    private final String minimumShouldMatch;
    private final String query;
    public static final JsonpDeserializer<CommonTermsQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CommonTermsQuery::setupCommonTermsQueryDeserializer);

    private CommonTermsQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.analyzer = builder.analyzer;
        this.cutoffFrequency = builder.cutoffFrequency;
        this.highFreqOperator = builder.highFreqOperator;
        this.lowFreqOperator = builder.lowFreqOperator;
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
    }

    public static CommonTermsQuery of(Function<Builder, ObjectBuilder<CommonTermsQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Common;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Double cutoffFrequency() {
        return this.cutoffFrequency;
    }

    @Nullable
    public final Operator highFreqOperator() {
        return this.highFreqOperator;
    }

    @Nullable
    public final Operator lowFreqOperator() {
        return this.lowFreqOperator;
    }

    @Nullable
    public final String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public final String query() {
        return this.query;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.cutoffFrequency != null) {
            generator.writeKey("cutoff_frequency");
            generator.write(this.cutoffFrequency.doubleValue());
        }
        if (this.highFreqOperator != null) {
            generator.writeKey("high_freq_operator");
            this.highFreqOperator.serialize(generator, mapper);
        }
        if (this.lowFreqOperator != null) {
            generator.writeKey("low_freq_operator");
            this.lowFreqOperator.serialize(generator, mapper);
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        generator.writeKey("query");
        generator.write(this.query);
        generator.writeEnd();
    }

    public Builder toBuilder() {
        return new Builder().field(this.field).analyzer(this.analyzer).cutoffFrequency(this.cutoffFrequency).highFreqOperator(this.highFreqOperator).lowFreqOperator(this.lowFreqOperator).minimumShouldMatch(this.minimumShouldMatch).query(this.query);
    }

    protected static void setupCommonTermsQueryDeserializer(ObjectDeserializer<Builder> op) {
        CommonTermsQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::cutoffFrequency, JsonpDeserializer.doubleDeserializer(), "cutoff_frequency");
        op.add(Builder::highFreqOperator, Operator._DESERIALIZER, "high_freq_operator");
        op.add(Builder::lowFreqOperator, Operator._DESERIALIZER, "low_freq_operator");
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("query");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CommonTermsQuery> {
        private String field;
        @Nullable
        private String analyzer;
        @Nullable
        private Double cutoffFrequency;
        @Nullable
        private Operator highFreqOperator;
        @Nullable
        private Operator lowFreqOperator;
        @Nullable
        private String minimumShouldMatch;
        private String query;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder cutoffFrequency(@Nullable Double value) {
            this.cutoffFrequency = value;
            return this;
        }

        public final Builder highFreqOperator(@Nullable Operator value) {
            this.highFreqOperator = value;
            return this;
        }

        public final Builder lowFreqOperator(@Nullable Operator value) {
            this.lowFreqOperator = value;
            return this;
        }

        public final Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CommonTermsQuery build() {
            this._checkSingleUse();
            return new CommonTermsQuery(this);
        }
    }
}

