/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class BoostingQuery
extends QueryBase
implements QueryVariant {
    private final double negativeBoost;
    private final Query negative;
    private final Query positive;
    public static final JsonpDeserializer<BoostingQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BoostingQuery::setupBoostingQueryDeserializer);

    private BoostingQuery(Builder builder) {
        super(builder);
        this.negativeBoost = ApiTypeHelper.requireNonNull(builder.negativeBoost, this, "negativeBoost");
        this.negative = ApiTypeHelper.requireNonNull(builder.negative, this, "negative");
        this.positive = ApiTypeHelper.requireNonNull(builder.positive, this, "positive");
    }

    public static BoostingQuery of(Function<Builder, ObjectBuilder<BoostingQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Boosting;
    }

    public final double negativeBoost() {
        return this.negativeBoost;
    }

    public final Query negative() {
        return this.negative;
    }

    public final Query positive() {
        return this.positive;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("negative_boost");
        generator.write(this.negativeBoost);
        generator.writeKey("negative");
        this.negative.serialize(generator, mapper);
        generator.writeKey("positive");
        this.positive.serialize(generator, mapper);
    }

    public Builder toBuilder() {
        return new Builder().negativeBoost(this.negativeBoost).negative(this.negative).positive(this.positive);
    }

    protected static void setupBoostingQueryDeserializer(ObjectDeserializer<Builder> op) {
        BoostingQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::negativeBoost, JsonpDeserializer.doubleDeserializer(), "negative_boost");
        op.add(Builder::negative, Query._DESERIALIZER, "negative");
        op.add(Builder::positive, Query._DESERIALIZER, "positive");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BoostingQuery> {
        private Double negativeBoost;
        private Query negative;
        private Query positive;

        public final Builder negativeBoost(double value) {
            this.negativeBoost = value;
            return this;
        }

        public final Builder negative(Query value) {
            this.negative = value;
            return this;
        }

        public final Builder negative(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.negative(fn.apply(new Query.Builder()).build());
        }

        public final Builder positive(Query value) {
            this.positive = value;
            return this;
        }

        public final Builder positive(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.positive(fn.apply(new Query.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BoostingQuery build() {
            this._checkSingleUse();
            return new BoostingQuery(this);
        }
    }
}

