/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.reindex_rethrottle;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.reindex_rethrottle.ReindexStatus;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ReindexTask
implements PlainJsonSerializable {
    private final String action;
    private final boolean cancellable;
    private final String description;
    private final long id;
    private final String node;
    private final long runningTimeInNanos;
    private final long startTimeInMillis;
    private final ReindexStatus status;
    private final String type;
    private final Map<String, List<String>> headers;
    public static final JsonpDeserializer<ReindexTask> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexTask::setupReindexTaskDeserializer);

    private ReindexTask(Builder builder) {
        this.action = ApiTypeHelper.requireNonNull(builder.action, this, "action");
        this.cancellable = ApiTypeHelper.requireNonNull(builder.cancellable, this, "cancellable");
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.runningTimeInNanos = ApiTypeHelper.requireNonNull(builder.runningTimeInNanos, this, "runningTimeInNanos");
        this.startTimeInMillis = ApiTypeHelper.requireNonNull(builder.startTimeInMillis, this, "startTimeInMillis");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.headers = ApiTypeHelper.unmodifiableRequired(builder.headers, (Object)this, "headers");
    }

    public static ReindexTask of(Function<Builder, ObjectBuilder<ReindexTask>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String action() {
        return this.action;
    }

    public final boolean cancellable() {
        return this.cancellable;
    }

    public final String description() {
        return this.description;
    }

    public final long id() {
        return this.id;
    }

    public final String node() {
        return this.node;
    }

    public final long runningTimeInNanos() {
        return this.runningTimeInNanos;
    }

    public final long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    public final ReindexStatus status() {
        return this.status;
    }

    public final String type() {
        return this.type;
    }

    public final Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("action");
        generator.write(this.action);
        generator.writeKey("cancellable");
        generator.write(this.cancellable);
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("running_time_in_nanos");
        generator.write(this.runningTimeInNanos);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("type");
        generator.write(this.type);
        if (ApiTypeHelper.isDefined(this.headers)) {
            generator.writeKey("headers");
            generator.writeStartObject();
            for (Map.Entry<String, List<String>> item0 : this.headers.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (String item1 : item0.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected static void setupReindexTaskDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::action, JsonpDeserializer.stringDeserializer(), "action");
        op.add(Builder::cancellable, JsonpDeserializer.booleanDeserializer(), "cancellable");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::id, JsonpDeserializer.longDeserializer(), "id");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::runningTimeInNanos, JsonpDeserializer.longDeserializer(), "running_time_in_nanos");
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis");
        op.add(Builder::status, ReindexStatus._DESERIALIZER, "status");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "headers");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ReindexTask> {
        private String action;
        private Boolean cancellable;
        private String description;
        private Long id;
        private String node;
        private Long runningTimeInNanos;
        private Long startTimeInMillis;
        private ReindexStatus status;
        private String type;
        private Map<String, List<String>> headers;

        public final Builder action(String value) {
            this.action = value;
            return this;
        }

        public final Builder cancellable(boolean value) {
            this.cancellable = value;
            return this;
        }

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder id(long value) {
            this.id = value;
            return this;
        }

        public final Builder node(String value) {
            this.node = value;
            return this;
        }

        public final Builder runningTimeInNanos(long value) {
            this.runningTimeInNanos = value;
            return this;
        }

        public final Builder startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return this;
        }

        public final Builder status(ReindexStatus value) {
            this.status = value;
            return this;
        }

        public final Builder status(Function<ReindexStatus.Builder, ObjectBuilder<ReindexStatus>> fn) {
            return this.status(fn.apply(new ReindexStatus.Builder()).build());
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder headers(Map<String, List<String>> map) {
            this.headers = Builder._mapPutAll(this.headers, map);
            return this;
        }

        public final Builder headers(String key, List<String> value) {
            this.headers = Builder._mapPut(this.headers, key, value);
            return this;
        }

        @Override
        public ReindexTask build() {
            this._checkSingleUse();
            return new ReindexTask(this);
        }
    }
}

