/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Intervals;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsFilter;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsQuery;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsQueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class IntervalsMatch
implements IntervalsQueryVariant,
IntervalsVariant,
JsonpSerializable {
    @Nullable
    private final String analyzer;
    @Nullable
    private final Integer maxGaps;
    @Nullable
    private final Boolean ordered;
    private final String query;
    @Nullable
    private final String useField;
    @Nullable
    private final IntervalsFilter filter;
    public static final JsonpDeserializer<IntervalsMatch> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IntervalsMatch::setupIntervalsMatchDeserializer);

    private IntervalsMatch(Builder builder) {
        this.analyzer = builder.analyzer;
        this.maxGaps = builder.maxGaps;
        this.ordered = builder.ordered;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.useField = builder.useField;
        this.filter = builder.filter;
    }

    public static IntervalsMatch of(Function<Builder, ObjectBuilder<IntervalsMatch>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public IntervalsQuery.Kind _intervalsQueryKind() {
        return IntervalsQuery.Kind.Match;
    }

    @Override
    public Intervals.Kind _intervalsKind() {
        return Intervals.Kind.Match;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Integer maxGaps() {
        return this.maxGaps;
    }

    @Nullable
    public final Boolean ordered() {
        return this.ordered;
    }

    public final String query() {
        return this.query;
    }

    @Nullable
    public final String useField() {
        return this.useField;
    }

    @Nullable
    public final IntervalsFilter filter() {
        return this.filter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.maxGaps != null) {
            generator.writeKey("max_gaps");
            generator.write(this.maxGaps.intValue());
        }
        if (this.ordered != null) {
            generator.writeKey("ordered");
            generator.write(this.ordered.booleanValue());
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.useField != null) {
            generator.writeKey("use_field");
            generator.write(this.useField);
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
    }

    public Builder toBuilder() {
        return new Builder().analyzer(this.analyzer).maxGaps(this.maxGaps).ordered(this.ordered).query(this.query).useField(this.useField).filter(this.filter);
    }

    protected static void setupIntervalsMatchDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::maxGaps, JsonpDeserializer.integerDeserializer(), "max_gaps");
        op.add(Builder::ordered, JsonpDeserializer.booleanDeserializer(), "ordered");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::useField, JsonpDeserializer.stringDeserializer(), "use_field");
        op.add(Builder::filter, IntervalsFilter._DESERIALIZER, "filter");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IntervalsMatch> {
        @Nullable
        private String analyzer;
        @Nullable
        private Integer maxGaps;
        @Nullable
        private Boolean ordered;
        private String query;
        @Nullable
        private String useField;
        @Nullable
        private IntervalsFilter filter;

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder maxGaps(@Nullable Integer value) {
            this.maxGaps = value;
            return this;
        }

        public final Builder ordered(@Nullable Boolean value) {
            this.ordered = value;
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        public final Builder useField(@Nullable String value) {
            this.useField = value;
            return this;
        }

        public final Builder filter(@Nullable IntervalsFilter value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<IntervalsFilter.Builder, ObjectBuilder<IntervalsFilter>> fn) {
            return this.filter(fn.apply(new IntervalsFilter.Builder()).build());
        }

        @Override
        public IntervalsMatch build() {
            this._checkSingleUse();
            return new IntervalsMatch(this);
        }
    }
}

