/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.MissingOrder;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregationCollectMode;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregationExecutionHint;
import org.opensearch.client.opensearch._types.aggregations.TermsExclude;
import org.opensearch.client.opensearch._types.aggregations.TermsInclude;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class TermsAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final TermsAggregationCollectMode collectMode;
    @Nullable
    private final TermsExclude exclude;
    @Nullable
    private final TermsAggregationExecutionHint executionHint;
    @Nullable
    private final String field;
    @Nullable
    private final TermsInclude include;
    @Nullable
    private final Integer minDocCount;
    @Nullable
    private final FieldValue missing;
    @Nullable
    private final MissingOrder missingOrder;
    @Nullable
    private final Boolean missingBucket;
    @Nullable
    private final String valueType;
    private final List<Map<String, SortOrder>> order;
    @Nullable
    private final Script script;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Boolean showTermDocCountError;
    @Nullable
    private final Integer size;
    public static final JsonpDeserializer<TermsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsAggregation::setupTermsAggregationDeserializer);

    private TermsAggregation(Builder builder) {
        super(builder);
        this.collectMode = builder.collectMode;
        this.exclude = builder.exclude;
        this.executionHint = builder.executionHint;
        this.field = builder.field;
        this.include = builder.include;
        this.minDocCount = builder.minDocCount;
        this.missing = builder.missing;
        this.missingOrder = builder.missingOrder;
        this.missingBucket = builder.missingBucket;
        this.valueType = builder.valueType;
        this.order = ApiTypeHelper.unmodifiable(builder.order);
        this.script = builder.script;
        this.shardSize = builder.shardSize;
        this.showTermDocCountError = builder.showTermDocCountError;
        this.size = builder.size;
    }

    public static TermsAggregation of(Function<Builder, ObjectBuilder<TermsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Terms;
    }

    @Nullable
    public final TermsAggregationCollectMode collectMode() {
        return this.collectMode;
    }

    @Nullable
    public final TermsExclude exclude() {
        return this.exclude;
    }

    @Nullable
    public final TermsAggregationExecutionHint executionHint() {
        return this.executionHint;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final TermsInclude include() {
        return this.include;
    }

    @Nullable
    public final Integer minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public final FieldValue missing() {
        return this.missing;
    }

    @Nullable
    public final MissingOrder missingOrder() {
        return this.missingOrder;
    }

    @Nullable
    public final Boolean missingBucket() {
        return this.missingBucket;
    }

    @Nullable
    public final String valueType() {
        return this.valueType;
    }

    public final List<Map<String, SortOrder>> order() {
        return this.order;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final Boolean showTermDocCountError() {
        return this.showTermDocCountError;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.collectMode != null) {
            generator.writeKey("collect_mode");
            this.collectMode.serialize(generator, mapper);
        }
        if (this.exclude != null) {
            generator.writeKey("exclude");
            this.exclude.serialize(generator, mapper);
        }
        if (this.executionHint != null) {
            generator.writeKey("execution_hint");
            this.executionHint.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.include != null) {
            generator.writeKey("include");
            this.include.serialize(generator, mapper);
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.intValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            this.missing.serialize(generator, mapper);
        }
        if (this.missingOrder != null) {
            generator.writeKey("missing_order");
            this.missingOrder.serialize(generator, mapper);
        }
        if (this.missingBucket != null) {
            generator.writeKey("missing_bucket");
            generator.write(this.missingBucket.booleanValue());
        }
        if (this.valueType != null) {
            generator.writeKey("value_type");
            generator.write(this.valueType);
        }
        if (ApiTypeHelper.isDefined(this.order)) {
            generator.writeKey("order");
            generator.writeStartArray();
            for (Map<String, SortOrder> item0 : this.order) {
                generator.writeStartObject();
                if (item0 != null) {
                    for (Map.Entry<String, SortOrder> item1 : item0.entrySet()) {
                        generator.writeKey(item1.getKey());
                        item1.getValue().serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.showTermDocCountError != null) {
            generator.writeKey("show_term_doc_count_error");
            generator.write(this.showTermDocCountError.booleanValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
    }

    protected static void setupTermsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        TermsAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::collectMode, TermsAggregationCollectMode._DESERIALIZER, "collect_mode");
        op.add(Builder::exclude, TermsExclude._DESERIALIZER, "exclude");
        op.add(Builder::executionHint, TermsAggregationExecutionHint._DESERIALIZER, "execution_hint");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::include, TermsInclude._DESERIALIZER, "include");
        op.add(Builder::minDocCount, JsonpDeserializer.integerDeserializer(), "min_doc_count");
        op.add(Builder::missing, FieldValue._DESERIALIZER, "missing");
        op.add(Builder::missingOrder, MissingOrder._DESERIALIZER, "missing_order");
        op.add(Builder::missingBucket, JsonpDeserializer.booleanDeserializer(), "missing_bucket");
        op.add(Builder::valueType, JsonpDeserializer.stringDeserializer(), "value_type");
        op.add(Builder::order, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(SortOrder._DESERIALIZER)), "order");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::showTermDocCountError, JsonpDeserializer.booleanDeserializer(), "show_term_doc_count_error");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TermsAggregation> {
        @Nullable
        private TermsAggregationCollectMode collectMode;
        @Nullable
        private TermsExclude exclude;
        @Nullable
        private TermsAggregationExecutionHint executionHint;
        @Nullable
        private String field;
        @Nullable
        private TermsInclude include;
        @Nullable
        private Integer minDocCount;
        @Nullable
        private FieldValue missing;
        @Nullable
        private MissingOrder missingOrder;
        @Nullable
        private Boolean missingBucket;
        @Nullable
        private String valueType;
        @Nullable
        private List<Map<String, SortOrder>> order;
        @Nullable
        private Script script;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Boolean showTermDocCountError;
        @Nullable
        private Integer size;

        public final Builder collectMode(@Nullable TermsAggregationCollectMode value) {
            this.collectMode = value;
            return this;
        }

        public final Builder exclude(@Nullable TermsExclude value) {
            this.exclude = value;
            return this;
        }

        public final Builder exclude(Function<TermsExclude.Builder, ObjectBuilder<TermsExclude>> fn) {
            return this.exclude(fn.apply(new TermsExclude.Builder()).build());
        }

        public final Builder executionHint(@Nullable TermsAggregationExecutionHint value) {
            this.executionHint = value;
            return this;
        }

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder include(@Nullable TermsInclude value) {
            this.include = value;
            return this;
        }

        public final Builder include(Function<TermsInclude.Builder, ObjectBuilder<TermsInclude>> fn) {
            return this.include(fn.apply(new TermsInclude.Builder()).build());
        }

        public final Builder minDocCount(@Nullable Integer value) {
            this.minDocCount = value;
            return this;
        }

        public final Builder missing(@Nullable FieldValue value) {
            this.missing = value;
            return this;
        }

        public final Builder missing(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.missing(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder missingOrder(@Nullable MissingOrder value) {
            this.missingOrder = value;
            return this;
        }

        public final Builder missingBucket(@Nullable Boolean value) {
            this.missingBucket = value;
            return this;
        }

        public final Builder valueType(@Nullable String value) {
            this.valueType = value;
            return this;
        }

        public final Builder order(List<Map<String, SortOrder>> list) {
            this.order = Builder._listAddAll(this.order, list);
            return this;
        }

        public final Builder order(Map<String, SortOrder> value, Map<String, SortOrder> ... values) {
            this.order = Builder._listAdd(this.order, value, values);
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public final Builder showTermDocCountError(@Nullable Boolean value) {
            this.showTermDocCountError = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermsAggregation build() {
            this._checkSingleUse();
            return new TermsAggregation(this);
        }
    }
}

