/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.termvectors;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.core.termvectors.FieldStatistics;
import org.opensearch.client.opensearch.core.termvectors.Term;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class TermVector
implements JsonpSerializable {
    private final FieldStatistics fieldStatistics;
    private final Map<String, Term> terms;
    public static final JsonpDeserializer<TermVector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermVector::setupTermVectorDeserializer);

    private TermVector(Builder builder) {
        this.fieldStatistics = builder.fieldStatistics;
        this.terms = ApiTypeHelper.unmodifiableRequired(builder.terms, (Object)this, "terms");
    }

    public static TermVector of(Function<Builder, ObjectBuilder<TermVector>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final FieldStatistics fieldStatistics() {
        return this.fieldStatistics;
    }

    public final Map<String, Term> terms() {
        return this.terms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (null != this.fieldStatistics) {
            generator.writeKey("field_statistics");
            this.fieldStatistics.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.terms)) {
            generator.writeKey("terms");
            generator.writeStartObject();
            for (Map.Entry<String, Term> item0 : this.terms.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupTermVectorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fieldStatistics, FieldStatistics._DESERIALIZER, "field_statistics");
        op.add(Builder::terms, JsonpDeserializer.stringMapDeserializer(Term._DESERIALIZER), "terms");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TermVector> {
        private FieldStatistics fieldStatistics;
        private Map<String, Term> terms;

        public final Builder fieldStatistics(FieldStatistics value) {
            this.fieldStatistics = value;
            return this;
        }

        public final Builder fieldStatistics(Function<FieldStatistics.Builder, ObjectBuilder<FieldStatistics>> fn) {
            return this.fieldStatistics(fn.apply(new FieldStatistics.Builder()).build());
        }

        public final Builder terms(Map<String, Term> map) {
            this.terms = Builder._mapPutAll(this.terms, map);
            return this;
        }

        public final Builder terms(String key, Term value) {
            this.terms = Builder._mapPut(this.terms, key, value);
            return this;
        }

        public final Builder terms(String key, Function<Term.Builder, ObjectBuilder<Term>> fn) {
            return this.terms(key, fn.apply(new Term.Builder()).build());
        }

        @Override
        public TermVector build() {
            this._checkSingleUse();
            return new TermVector(this);
        }
    }
}

