/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot.get;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.opensearch.snapshot.SnapshotInfo;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class SnapshotResponseItem
implements JsonpSerializable {
    private final String repository;
    private final List<SnapshotInfo> snapshots;
    @Nullable
    private final ErrorCause error;
    public static final JsonpDeserializer<SnapshotResponseItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotResponseItem::setupSnapshotResponseItemDeserializer);

    private SnapshotResponseItem(Builder builder) {
        this.repository = ApiTypeHelper.requireNonNull(builder.repository, this, "repository");
        this.snapshots = ApiTypeHelper.unmodifiable(builder.snapshots);
        this.error = builder.error;
    }

    public static SnapshotResponseItem of(Function<Builder, ObjectBuilder<SnapshotResponseItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String repository() {
        return this.repository;
    }

    public final List<SnapshotInfo> snapshots() {
        return this.snapshots;
    }

    @Nullable
    public final ErrorCause error() {
        return this.error;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("repository");
        generator.write(this.repository);
        if (ApiTypeHelper.isDefined(this.snapshots)) {
            generator.writeKey("snapshots");
            generator.writeStartArray();
            for (SnapshotInfo item0 : this.snapshots) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
    }

    protected static void setupSnapshotResponseItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::repository, JsonpDeserializer.stringDeserializer(), "repository");
        op.add(Builder::snapshots, JsonpDeserializer.arrayDeserializer(SnapshotInfo._DESERIALIZER), "snapshots");
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SnapshotResponseItem> {
        private String repository;
        @Nullable
        private List<SnapshotInfo> snapshots;
        @Nullable
        private ErrorCause error;

        public final Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public final Builder snapshots(List<SnapshotInfo> list) {
            this.snapshots = Builder._listAddAll(this.snapshots, list);
            return this;
        }

        public final Builder snapshots(SnapshotInfo value, SnapshotInfo ... values) {
            this.snapshots = Builder._listAdd(this.snapshots, value, values);
            return this;
        }

        public final Builder snapshots(Function<SnapshotInfo.Builder, ObjectBuilder<SnapshotInfo>> fn) {
            return this.snapshots(fn.apply(new SnapshotInfo.Builder()).build(), new SnapshotInfo[0]);
        }

        public final Builder error(@Nullable ErrorCause value) {
            this.error = value;
            return this;
        }

        public final Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        @Override
        public SnapshotResponseItem build() {
            this._checkSingleUse();
            return new SnapshotResponseItem(this);
        }
    }
}

