/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: FactoryService.java 2673 2006-05-26 21:08:46Z jmettraux $
 */

//
// FactoryService.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org;

/**
 * A service that builds instances
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-05-26 23:08:46 +0200 (Fri, 26 May 2006) $
 * <br>$Id: FactoryService.java 2673 2006-05-26 21:08:46Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class FactoryService

    extends AbstractService

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(FactoryService.class.getName());
    */

    //
    // CONSTANTS (definitions)

    public final static String SERVICE_CLASS
        = "serviceClass";

    //
    // FIELDS

    private Class serviceClass = null;

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        String className = MapUtils
            .getMandatoryString(getParams(), SERVICE_CLASS);

        try
        {
            this.serviceClass = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe)
        {
            throw new ServiceException
                ("Cannot find class '"+className+"'", cnfe);
        }

        if ( ! Service.class.isAssignableFrom(this.serviceClass))
        {
            throw new ServiceException
                ("Cannot set up a factory for class '"+className+
                 "', it's not implementing "+Service.class.getName());
        }
    }

    //
    // METHODS from Service

    //
    // METHODS

    public Service buildService ()
        throws ServiceException
    {
        Service newService = null;

        try
        {
            newService = (Service)this.serviceClass.newInstance();
        }
        catch (Exception e)
        {
            throw new ServiceException
                ("Failed to build service of class '"+
                 this.serviceClass.getName()+"'", e);
        }

        final String name = getName() + "." + System.currentTimeMillis();

        try
        {
            newService.init(name, getContext(), getParams());
        }
        catch (ServiceException se)
        {
            throw new ServiceException
                ("Failed to init service of class '"+
                 this.serviceClass.getName()+"' just built", se);
        }

        return newService;
    }

}
