/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: StackMap.java 2673 2006-05-26 21:08:46Z jmettraux $
 */

//
// StackMap.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org;

/**
 * A map of stacks, where each key matches a stack of objects
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: StackMap.java 2673 2006-05-26 21:08:46Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class StackMap
{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(StackMap.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    private final java.util.Map map = new java.util.HashMap();

    //
    // CONSTRUCTORS

    //
    // METHODS

    /**
     * Pushes a value in the stack mapped to the Object key.
     */
    public void push (final Object key, final Object value)
    {
        if (key == null || value == null)
        {
            throw new IllegalArgumentException
                ("Key and/or value may not be null");
        }

        stack(this.map, key, value);
    }

    /**
     * Unstacks and returns the last object pushed for the given key.
     */
    public Object pop (final Object key)
    {
        final java.util.LinkedList values = 
            (java.util.LinkedList)this.map.get(key);

        if (values == null || values.size() < 1) return null;

        return values.removeLast();
    }

    /**
     * Unstacks and returns the first object pushed for the given key.
     */
    public Object popFirst (final Object key)
    {
        final java.util.LinkedList values = 
            (java.util.LinkedList)this.map.get(key);

        if (values == null || values.size() < 1) return null;

        return values.removeFirst();
    }

    //
    // STATIC METHODS

    /**
     * Does the work of storing values in lists mapped to keys.
     * This method has been made static as it's used directly by some classes
     * that don't want to bother with a (closed) StackMap instance.
     */
    public static void stack 
        (final java.util.Map m, final Object key, Object value)
    {
        java.util.List values = (java.util.List)m.get(key);

        if (values == null) 
        {
            values = new java.util.LinkedList();
            m.put(key, values);
        }

        values.add(value);
    }

}
