/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: LoginModule.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// LoginModule.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.auth;

import javax.security.auth.Subject;
//import javax.security.auth.spi.LoginModule;
import javax.security.auth.login.LoginException;
import javax.security.auth.callback.CallbackHandler;
import openwfe.org.ApplicationContext;


/**
 * There is only login() left to implement...
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-01 16:38:45 +0200 (Thu, 01 Jun 2006) $
 * <br>$Id: LoginModule.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class LoginModule

    implements javax.security.auth.spi.LoginModule

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(LoginModule.class.getName());

    //
    // CONSTANTS and definitions

    public final static String APPLICATION = "application";
    public final static String POLICY_SERVICE = "policyService";

    //
    // FIELDS

    protected Subject subject = null;
    protected CallbackHandler handler = null;
    protected java.util.Map sharedState = null;
    protected java.util.Map options = null;

    protected Principal principal = null;

    protected boolean succeeded = false;
    protected boolean commitSucceeded = false;

    protected PolicyService policyService = null;

    //
    // CONSTRUCTORS

    //
    // METHODS from javax.security.auth.spi.LoginModule

    public void initialize
        (final Subject subject, 
         final CallbackHandler callbackHandler, 
         final java.util.Map sharedState, 
         final java.util.Map options)
    {
        this.subject = subject;
        this.handler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;

        String applicationName = 
            (String)this.options.get(APPLICATION);
        String policyService = 
            (String)this.options.get(POLICY_SERVICE);

        if (applicationName == null ||
            policyService == null)
        {
            log.warn
                ("initialize() login module parameters '"+APPLICATION+
                 "' and '"+POLICY_SERVICE+"' are mandatory");
        }

        ApplicationContext context = 
            ApplicationContext.lookupContext(applicationName);
        if (context == null)
        {
            log.warn
                ("initialize() Application context named '"+
                 applicationName+"' not found. No login possible.");
        }

        this.policyService = PolicyService.lookupPolicyService(context);

        if (this.policyService == null || 
            ! (this.policyService instanceof PolicyService))
        {
            log.warn
                ("Application '"+APPLICATION+
                 "' doesn't contain a policy service named '"+
                 POLICY_SERVICE+"'");
        }
    }

    public boolean commit () 
        throws LoginException
    {
        if ( ! this.succeeded)
            //
            // this login module failed : clean up.
        {
            log.debug("commit() Login hasn't succeeded");
            return false;
        }

        log.debug("commit() Login has succeeded");

        //
        // pre-login clean up

        // nada

        //
        // add principal to subject

        if ( ! this.subject.getPrincipals().contains(this.principal))
        {
            this.subject.getPrincipals().add(this.principal);

            //log.debug("Adding principal\n"+this.principal.toString());
        }

        //
        // post-login clean up

        this.commitSucceeded = true;
        return true;
    }

    public boolean abort () 
        throws LoginException
    {
        if (this.succeeded = false)
            // we failed too
        {
            return false;
        }
        else if (this.commitSucceeded)
            // another module failed
        {
            logout();
        }
        else
            // our commit failed
        {
            this.succeeded = false;
        }

        return true;
    }

    public boolean logout () 
        throws LoginException
    {
        this.subject.getPrincipals().remove(this.principal);
            // if any

        this.principal = null;
        //this.userEntry = null;
        this.succeeded = false;
        this.commitSucceeded = false;

        return true;
    }


    //
    // METHODS

}
