/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: StupidCallbackHandler.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// StupidCallbackHandler.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.auth;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import openwfe.org.ServiceException;


/**
 * A simple text callback handler
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-01 16:38:45 +0200 (Thu, 01 Jun 2006) $
 * <br>$Id: StupidCallbackHandler.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class StupidCallbackHandler

    implements OwfeCallbackHandler

{

    //
    // FIELDS

    private String userName = null;
    private String hashedPassword = null;

    //
    // CONSTRUCTORS

    public void init (Object o)
        throws ServiceException
    {
        if ( ! (o instanceof String[]))
        {
            throw new ServiceException
                ("this class can only be initted with a String array");
        }

        try
        {
            String[] ss = (String[])o;

            this.userName = ss[0];
            this.hashedPassword = ss[1];
        }
        catch (Throwable t)
        {
            throw new ServiceException
                ("Failed to init", t);
        }
    }

    //
    // METHODS from CallbackHandler

    public void handle (Callback[] cbs)
        throws java.io.IOException, UnsupportedCallbackException
    {
        for (int i=0; i<cbs.length; i++)
        {
            //
            // username

            if (cbs[i] instanceof NameCallback)
            {
                NameCallback ncb = (NameCallback)cbs[i];

                ncb.setName(this.userName);
            }
            else if (cbs[i] instanceof PasswordCallback)
            {
                //
                // password

                PasswordCallback pcb = (PasswordCallback)cbs[i];

                pcb.setPassword(this.hashedPassword.toCharArray());

                this.hashedPassword = null;
            }
            else
            {
                throw new UnsupportedCallbackException
                    (cbs[i], StupidCallbackHandler.class.getName());
            }
        }
    }

    //
    // METHODS

}
