/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: UmanPermission.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// UmanPermission.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.auth;

import java.security.PermissionCollection;
import openwfe.org.auth.Permission;


/**
 * A permission for a workitem store
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-01 16:38:45 +0200 (Thu, 01 Jun 2006) $
 * <br>$Id: UmanPermission.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class UmanPermission

    extends Permission

{

    /*
    private final static org.apache.log4j.Logger log =
        org.apache.log4j.Logger.getLogger(UmanPermission.class.getName());
    */

    //
    // CONSTANTS (definitions)

    public final static String UMAN_ACTIONS 
        = "manage";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    public UmanPermission (final java.util.Map params)
    {
        super(params);
    }

    //
    // METHODS

    //
    // METHODS from Permission

    public String getActions ()
    {
        return UMAN_ACTIONS;
    }

    public int hashCode ()
    {
        return this.getName().hashCode();
    }

    public boolean equals (Object o)
    {
        if (o == null || ! (o instanceof UmanPermission)) return false;

        UmanPermission other = (UmanPermission)o;

        return 
            (getName().equals(other.getName()));
    }

    public boolean implies (java.security.Permission p)
    {
        if (p == null || ! (p instanceof UmanPermission)) return false;

        UmanPermission other = (UmanPermission)p;

        return (this.getName().equals(other.getName()));
    }

    public PermissionCollection newPermissionCollection ()
    {
        return new UmanPermissionCollection();
    }

    public String toString ()
    {
        StringBuffer sb = new StringBuffer();

        sb.append("<UmanPermission \n  name=\"");
        sb.append(getName());
        sb.append("\" \n/>");

        return sb.toString();
    }

}

//
// ANOTHER CLASS

//
// UmanPermissionCollection.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

/**
 * no comment
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-01 16:38:45 +0200 (Thu, 01 Jun 2006) $
 * <br>$Id: UmanPermission.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
final class UmanPermissionCollection

    extends PermissionCollection

    implements java.io.Serializable

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(UmanPermissionCollection.class.getName());

    //
    // FIELDS

    private java.util.Vector permissions = new java.util.Vector();

    //
    // CONSTRUCTORS

    //
    // METHODS

    public void add (java.security.Permission p)
    {
        if (p == null || ! (p instanceof UmanPermission))
        {
            throw new IllegalArgumentException
                ("null permission or permission not of class '"+
                 UmanPermission.class.getName()+"'");
        }

        if (isReadOnly())
        {
            throw new SecurityException
                ("attempt to add a Permission to a readonly "+
                 "PermissionCollection");
        }

        this.permissions.add(p);
    }

    public boolean implies (final java.security.Permission p)
    {
        if (p == null || ! (p instanceof UmanPermission)) return false;

        final java.util.Enumeration en = elements();
        while(en.hasMoreElements())
        {
            UmanPermission elp = (UmanPermission)en.nextElement();

            //log.debug("does "+elp+" implies "+p+" ?");

            if (elp.implies(p)) return true;
        }

        return false;
    }

    public java.util.Enumeration elements ()
    {
        return this.permissions.elements();
    }

}

