/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SignedObject.java 1882 2005-05-17 16:41:07Z jmettraux $
 */

//
// SignedObject.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.crypto;

import java.security.Signature;

import openwfe.org.misc.ByteUtils;


/**
 * A SignedObject that is XML serializable
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-05-17 18:41:07 +0200 (Tue, 17 May 2005) $
 * <br>$Id: SignedObject.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class SignedObject

    implements java.io.Serializable

{

    //
    // FIELDS

    private java.io.Serializable object = null;
    private String signature = null;

    //
    // CONSTRUCTORS

    public SignedObject ()
    {
        super();
    }

    public SignedObject 
        (final java.io.Serializable object, final RsaKey privateKey)
    throws CryptoException
    {
        super();

        this.object = object;

        try
        {
            Signature sig = Signature.getInstance("MD5withRSA");

            sig.initSign
                ((java.security.PrivateKey)privateKey.assembleRealKey());
            sig.update
                (ByteUtils.objectToByteArray(this.object));

            this.signature = ByteUtils.toString(sig.sign());
        }
        catch (Exception e)
        {
            throw new CryptoException
                ("Failed to sign object", e);
        }
    }

    //
    // BEAN METHODS

    public java.io.Serializable getObject () { return this.object; }
    public String getSignature () { return this.signature; }

    public void setObject (java.io.Serializable s) { this.object = s; }
    public void setSignature (String ba) { this.signature = ba; }

    //
    // METHODS

    public boolean verify (RsaKey publicKey)
        throws CryptoException
    {
        try
        {
        Signature sig = Signature.getInstance("MD5withRSA");
        sig.initVerify((java.security.PublicKey)publicKey.assembleRealKey());
        sig.update(ByteUtils.objectToByteArray(this.object));
        return sig.verify(ByteUtils.fromString(this.signature));
        }
        catch (Exception e)
        {
            throw new CryptoException
                ("Failed to verify signed object", e);
        }
    }

    //
    // STATIC METHODS

    /*
    public static void main (String[] args)
    {
        try
        {
            java.io.Serializable object = 
                "Les sanglots longs des violons de l'automne "+
                "bercent mon coeur d'une langueur monotone.";

            RsaKey[] pair = RsaKey.generateKeyPair(2048);

            SignedObject so = new SignedObject(object, pair[1]);

            java.beans.XMLEncoder encoder = 
                new java.beans.XMLEncoder(System.out);

            encoder.writeObject(so);
            encoder.flush();

            System.out.println
                ("\n\nVerification successful : "+so.verify(pair[0]));
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }
    */

}
