/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ArgParser.java 2673 2006-05-26 21:08:46Z jmettraux $
 */

//
// Args.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.misc;

/**
 * Parsing 'function line' arguments.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ArgParser.java 2673 2006-05-26 21:08:46Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ArgParser
{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ArgParser.class.getName());
    */

    //
    // CONSTANTS

    //
    // FIELDS

    private char quote = '\'';

    //
    // CONSTRUCTORS

    /**
     * Builds an argument parser waiting for things like
     * "'ab', 'c,d', 'efg'"
     */
    public ArgParser ()
    {
        super();
    }

    /**
     * Builds an argument parser whose quote is not the "'" default.
     */
    public ArgParser (final char quote)
    {
        super();

        this.quote = quote;
    }

    //
    // METHODS

    public String[] parse (final String rawArgs)
    {
        String raw = rawArgs.trim();

        if (raw == null || raw.length() < 1) return new String[] {};

        Object result = null;

        if (raw.indexOf(this.quote) < 0)
        {
            result = parseWithoutQuote(raw);
        }
        else
        {
            result = parse(new java.util.ArrayList(7), raw);
        }

        if (result instanceof String[]) return (String[])result;

        final java.util.List l = (java.util.List)result;

        final String[] args = new String[l.size()];

        for (int i=0; i<l.size(); i++)
            args[i] = (String)l.get(i);

        return args;
    }

    private java.util.List parse (final java.util.List l, final String raw)
    {
        //log.debug("parse() >"+raw+"<");

        if (raw == null || raw.length() < 1) return l;

        int i = 0;
        boolean backslashed = false;
        final StringBuffer sb = new StringBuffer();

        for (; i < raw.length(); i++)
        {
            char c = raw.charAt(i);

            if (i == 0 && c == this.quote) continue;

            if (c == '\\' && !backslashed)
            {
                backslashed = true;
                continue;
            }

            if (backslashed)
            {
                if (c != this.quote) sb.append('\\');

                sb.append(c);

                backslashed = false;

                continue;
            }

            if (c == this.quote) break;

            sb.append(c);
        }

        final String arg = sb.toString();

        l.add(sb.toString());

        //log.debug("added >"+sb.toString()+"<");

        //log.debug("i = "+i);

        if (i >= raw.length()) return l;

        String nextRaw = raw.substring(i+1).trim();

        int q = nextRaw.indexOf(this.quote);

        if (q > -1) nextRaw = nextRaw.substring(q+1);

        return parse (l, nextRaw);
    }

    private Object parseWithoutQuote (final String raw)
    {
        //log.debug("parseWithoutQuote() >"+raw+"<");

        if (raw.indexOf(",") > -1) return raw.split(",\\s*");

        return trim(raw.split("\\s+"));
    }

    private java.util.List trim (final String[] ss)
    {
        final java.util.List l = new java.util.ArrayList(ss.length);

        for (int i=0; i<ss.length; i++)
        {
            final String s = ss[i].trim();

            if (s.length() < 1) continue;

            //log.debug("trim() adding >"+s+"<");

            l.add(s);
        }

        return l;
    }

    //
    // STATIC METHODS

    /*
    public static void main (String[] args)
        throws Exception
    {
        final ArgParser parser = new ArgParser();
        //final String[] ss = parser.parse(args[0]);
        final String[] ss = parser.parse("'a' 'b' 'c'");

        for (int i=0; i<ss.length; i++)
        {
            System.out.println(" >"+ss[i]+"<");
        }
    }
    */

}
