/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ByteUtils.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// ByteUtils.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.misc;

/**
 * Just static methods for turning strings into byte arrays and vice versa.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-01 16:38:45 +0200 (Thu, 01 Jun 2006) $
 * <br>$Id: ByteUtils.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public abstract class ByteUtils
{

    public static byte[] objectToByteArray (Object o)
        throws ByteException
    {
        return objectsToByteArray(new Object[] { o });
    }

    public static byte[] objectsToByteArray (Object[] objects)
        throws ByteException
    {
        java.io.ByteArrayOutputStream os = new java.io.ByteArrayOutputStream();
        java.beans.XMLEncoder encoder = new java.beans.XMLEncoder(os);

        try
        {
            for (int i=0; i<objects.length; i++)
            {
                if (objects[i] == null) continue;

                encoder.writeObject(objects[i]);
                encoder.flush();
            }
        }
        catch (final Throwable t)
        {
            throw new ByteException
                ("Failed to encode objects", t);
        }

        return os.toByteArray();
    }

    public static String toString (byte[] ba)
    {
        StringBuffer sb = new StringBuffer();

        for (int i=0; i<ba.length; i++)
        {
            if (ba[i] >= 0) sb.append('+');
            sb.append(ba[i]);
        }

        return sb.toString();
    }

    public static int toByte (String s)
    {
        if (s.charAt(0) == '+') s = s.substring(1);

        return Integer.parseInt(s);
    }

    public static byte[] fromString (String s)
        throws NumberFormatException
    {
        java.io.ByteArrayOutputStream os = new java.io.ByteArrayOutputStream();

        String currentByte = ""+s.charAt(0);

        for (int i=1; i<s.length(); i++)
        {
            char c = s.charAt(i);

            if (c == '+' || c == '-')
            {
                os.write(toByte(currentByte));
                currentByte = ""+c;
                continue;
            }
            
            currentByte += c;
        }

        os.write(toByte(currentByte));

        return os.toByteArray();
    }

}
