/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SignalClient.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// SignalClient.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.misc;

/**
 * A command-line client for sending signals to a signal service.
 * Is mainly used by stop scripts to stop an OpenWFE application.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: SignalClient.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class SignalClient
{

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // STATIC METHODS

    /**
     * This method is used by the SignalClient main method to do the job,
     * it can be used as well by any other application to send a signal.
     */
    public static void sendSignal (final int port, final String signal)
        throws java.io.IOException
    {
        final java.net.Socket socket = 
            new java.net.Socket("127.0.0.1", port);

        final java.io.PrintWriter out = 
            new java.io.PrintWriter(socket.getOutputStream());

        out.print(signal);
        out.flush();
        out.close();

        socket.close();
    }

    private static void printUsage (String command)
    {
        if (command == null)
            command = "java "+SignalClient.class.getName();

        System.out.println("\nUSAGE :\n");
        System.out.println("   "+command+" {port} {signal}\n");
        System.out.println("      the main signal known by OpenWFE applications is 'STOP'");
        System.out.println("      {port} may be a comma separated list of ports\n");
    }

    /**
     * The main method of the client.
     */
    public static void main (final String[] args)
        throws Exception
    {
        if (args.length < 2)
        {
            printUsage(null);
            System.exit(2);
        }

        int index = 0;
        String command = null;

        if (args[0].equals("-c"))
        {
            command = args[1];
            index = 2;
        }

        if (args.length < index+2)
        {
            printUsage(command);
            System.exit(1);
        }

        final String[] sPorts = args[index++].split(",");
        final String signal = args[index];

        int exitCode = 0;

        for (int i=0; i<sPorts.length; i++)
        {
            final int port = Integer.parseInt(sPorts[i]);

            try
            {
                sendSignal(port, signal);

                System.out.println
                    ("Sent signal '"+signal+"' to localhost:"+port);
            }
            catch (java.net.ConnectException ce)
            {
                System.out.println
                    ("Couldn't connect to port "+port);

                exitCode = 3;
            }
        }

        System.exit(exitCode);
    }

}
