/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WebUtils.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// WebUtils.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.misc;

import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * Some helper methods
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: WebUtils.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class WebUtils
{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(WebUtils.class.getName());
    */

    //
    // METHODS

    /**
     * Logs through the servlet container logging facility.
     * If no HttpSession session has been started, nothing will get logged.
     */
    public static void log 
        (final HttpServletRequest req, final String message)
    {
        log(req, message, null);
    }

    /**
     * Logs through the servlet container logging facility.
     * If no HttpSession session has been started, nothing will get logged.
     */
    public static void log 
        (final HttpServletRequest req, final String message, final Throwable t)
    {
        final HttpSession hs = req.getSession();

        if (hs == null) return;

        log(hs, message, t);
    }

    /**
     * Logs through the servlet container logging facility.
     */
    public static void log
        (final HttpSession ses, final String message)
    {
        log(ses, message, null);
    }

    /**
     * Logs through the servlet container logging facility.
     */
    public static void log
        (final HttpSession ses, final String message, final Throwable t)
    {
        if (t == null)
            ses.getServletContext().log(message);
        else
            ses.getServletContext().log(message, t);
    }

    /**
     * forwards a web request to a given URL
     */
    public static void forward 
        (HttpServletRequest req, HttpServletResponse res, String url)
    throws
        java.io.IOException, ServletException
    {
        RequestDispatcher rd = req.getRequestDispatcher(url);
        rd.forward(req, res);
    }

    /**
     * Includes a file in a web page (its writer)
     */
    public static void include (PrintWriter out, String fileName)
        //throws java.io.IOException 
    {
        try
        {
            java.io.BufferedReader br = 
                new java.io.BufferedReader(new java.io.FileReader(fileName));

            while (true)
            {
                String line = br.readLine();
                if (line == null) break;
                out.println(line);
            }

            br.close();
        }
        catch (final Exception e)
        {
            final java.io.File f = new java.io.File(fileName);

            out.println
                ("<font color=red>Failed to include file '"+
                 f.getAbsolutePath()+"'");

            out.println("<br>"+e);
            out.println("</font>");
        }
    }

    /**
     * Includes a URL in a web page (its writer)
     */
    public static void include (PrintWriter out, java.net.URL url)
    {
        try
        {
            java.io.BufferedReader br = new java.io.BufferedReader
                (new java.io.InputStreamReader
                    (url.openConnection().getInputStream()));

            while (true)
            {
                String line = br.readLine();
                if (line == null) break;
                out.println(line);
            }

            br.close();
        }
        catch (Exception e)
        {
            out.println("<font color=red>Failed to include URL "+url);
            out.println("<br>"+e);
            out.println("</font>");
        }
    }

}
