/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WebUtils.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// Web.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.net;

import javax.servlet.http.HttpServletRequest;


/**
 * Some methods to use in webapplications
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: WebUtils.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class WebUtils
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(WebUtils.class.getName());

    //
    // STATIC METHODS

    /**
     * (I should really replace this with quote and unquote stuff)
     */
    public static String neutralize (final String html)
    {
        if (html == null) return "null";

        String s = html;
        s.replaceAll(">", "&gt;");
        s.replaceAll("<", "&lt;");
        return s;
    }

    /**
     * Turns something like 'http://localhost:7080/nada' into
     * 'http://absolute.path.com/nada'.
     */
    public static String makeUrlAbsolute (final String url)
    {
        if (url.indexOf("/localhost/") < 0) return url;
        if (url.indexOf("/localhost:") < 0) return url;

        String hostname = "localhost";
        try
        {
            hostname = java.net.InetAddress.getLocalHost().getHostName();
        }
        catch (final Throwable t)
        {
            // ignore
        }

        return url.replaceFirst("localhost", hostname);
    }

    /**
     * (I can't remember if Sun's servlet API already provides this method 
     * for making a link absolute...)
     * Anyway, this method returns the webapp root URL path, it's heavily used
     * in Droflo for it to be usable from :7080/droflo or from :7085/
     */
    public static String getWebappUrl (final HttpServletRequest req)
    {
        final String href = req.getRequestURL().toString();

        int index = 0;
        for (int i=0; i<4; i++)
        {
            index += (href.substring(index).indexOf("/") + 1);
        }

        String rootPath = href.substring(0, index);

        if (log.isDebugEnabled())
            log.debug("getWebappUrl()  0 rootPath is >"+rootPath+"<");

        if (rootPath.indexOf("/") == rootPath.lastIndexOf("/"))
        {
            final String webappName = 
                req.getSession().getServletContext().getServletContextName();

            if (log.isDebugEnabled())
                log.debug("getWebappUrl()  1 webappName is >"+webappName+"<");

            if (webappName != null &&  !webappName.equals("/"))
                rootPath += webappName;
        }

        if (log.isDebugEnabled())
            log.debug("getWebappUrl() -1 rootPath is >"+rootPath+"<");

        return rootPath;
    }

}
