/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: RunnableWorkSessionServer.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// AbstractWorkSessionServer.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.rmi.session;

import openwfe.org.Utils;
import openwfe.org.MapUtils;
import openwfe.org.Service;
import openwfe.org.RunnableService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.state.ServiceState;
import openwfe.org.state.ServiceStateHelper;


/**
 * Half an implementation of a WorkSessionServer 
 * (just registering the RemoteSession class).
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: RunnableWorkSessionServer.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class RunnableWorkSessionServer

    extends java.rmi.server.UnicastRemoteObject

    implements RunnableService

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(RunnableWorkSessionServer.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    private String serviceName = null;
    private ApplicationContext applicationContext = null;
    private java.util.Map serviceParams = null;

    private ServiceStateHelper serviceStateHelper = null;

    //
    // CONSTRUCTORS

    public RunnableWorkSessionServer ()
        throws java.rmi.RemoteException
    {
        super();
    }

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        this.serviceName = serviceName;
        this.applicationContext = context;
        this.serviceParams = serviceParams;

        this.serviceStateHelper = new ServiceStateHelper(this.serviceName);
    }

    //
    // METHODS from Service

    /**
     * Returns the name of the service
     */
    public String getName ()
    {
        return this.serviceName;
    }

    /**
     * Returns the application context this instance lives in.
     */
    public ApplicationContext getContext ()
    {
        return this.applicationContext;
    }

    /**
     * Returns the initialization parameters of this instance.
     */
    public java.util.Map getParams ()
    {
        return this.serviceParams;
    }

    //
    // Methods from OwfeRunnable

    /**
     * Will return true if the service is in the 'running' state.
     */
    public boolean isRunning ()
    {
        return this.serviceStateHelper.isRunning();
    }

    public ServiceState getState ()
    {
        return this.serviceStateHelper.getState();
    }

    public void play ()
        throws ServiceException
    {
        this.serviceStateHelper.play();
    }

    public void pause ()
        throws ServiceException
    {
        this.serviceStateHelper.pause();
    }

    public void stop ()
        throws ServiceException
    {
        this.serviceStateHelper.stop();
    }

    public void update ()
        throws ServiceException
    {
        this.serviceStateHelper.update();
    }

    //
    // METHODS

}
