/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AdHocDataSource.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// AdHocDataSource.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.sql.ds;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;


/**
 * A data source for embedded OpenWFE ease of use : simply wraps a SQL
 * connection or a SQL datasource.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: AdHocDataSource.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class AdHocDataSource

    extends OwfeDataSource

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AdHocDataSource.class.getName());
    */

    //
    // CONSTANTS & co

    /**
     * An adhoc data source awaits either a 'datasource' or a 'connection'
     * parameter, if both may be found, the datasource will be used ;
     * The datasource or the connection will then get wrapped and used, it
     * allows thus a developer to set up its connection the way he likes and
     * to then make it available to OpenWFE components through this 
     * OwfeDataSource implementation.
     */
    public final static String P_DATASOURCE
        = "datasource";

    /**
     * An adhoc data source awaits either a 'datasource' or a 'connection'
     * parameter, if both may be found, the datasource will be used ;
     * The datasource or the connection will then get wrapped and used, it
     * allows thus a developer to set up its connection the way he likes and
     * to then make it available to OpenWFE components through this 
     * OwfeDataSource implementation.
     */
    public final static String P_CONNECTION
        = "connection";

    //
    // FIELDS

    //private Connection wrappedConnection = null;

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        DataSource datasource = 
            (DataSource)serviceParams.get(P_DATASOURCE);

        final Connection connection = 
            (Connection)serviceParams.get(P_CONNECTION);

        if (datasource == null)
        {
            if (connection == null)
            {
                throw new ServiceException
                    ("Parameter 'datasource' or 'connection' is missing, "+
                     "cannot set up AdHocDataSource");
            }

            //this.wrappedConnection = connection;

            datasource = new DataSource()
                //
                // only implements getConnection()
            {
                public Connection getConnection ()
                    throws SQLException
                {
                    //return wrappedConnection;
                    return connection;
                }

                public Connection getConnection (String u, String p)
                    throws SQLException
                {
                    return null;
                }

                public void setLogWriter (java.io.PrintWriter w)
                    throws SQLException
                {
                }

                public java.io.PrintWriter getLogWriter ()
                {
                    return null;
                }

                public void setLoginTimeout (int seconds)
                    throws SQLException
                {
                }

                public int getLoginTimeout ()
                {
                    return -1;
                }
            };
        }

        this.setDataSource(datasource);
    }

    //
    // METHODS

    //
    // METHODS from OwfeDataSource

    /**
     * Returns null : an AdHocDataSource instance will thus never
     * check if its wrapped connection is valid.
     */
    public String getConnectionValiditySqlCode ()
    {
        return null;
    }

    //
    // STATIC METHODS

}
