/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: PostgresDataSource.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// PostgresDataSource.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.sql.ds;

import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import org.postgresql.jdbc3.Jdbc3SimpleDataSource;


/**
 * An implementation of OwfeDataSource for PostgreSQL databases.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-01 16:38:45 +0200 (Thu, 01 Jun 2006) $
 * <br>$Id: PostgresDataSource.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class PostgresDataSource

    extends OwfeDataSource

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(PostgresDataSource.class.getName());

    //
    // CONSTANTS (definitions)

    /**
     * This datasource usually requires a 'user' attribute to be defined.
     */
    public final static String P_USER = "user";

    /**
     * This datasource usually requires a 'pass' attribute to be defined.
     */
    public final static String P_PASS = "pass";


    private final static String CON_VALIDITY_SQL_CODE
        = "SELECT 1";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        final String url = MapUtils.getMandatoryString(getParams(), P_URL);
        final String user = MapUtils.getMandatoryString(getParams(), P_USER);
        final String pass = MapUtils.getMandatoryString(getParams(), P_PASS);

        final Jdbc3SimpleDataSource ds = new Jdbc3SimpleDataSource();
        setUpDataSource(ds, url, user, pass);
        setDataSource(ds);
    }

    //
    // METHODS

    protected void setUpDataSource 
        (final Jdbc3SimpleDataSource source, 
         String url, 
         final String user,
         final String pass)
    throws 
        ServiceException
    {
        source.setUser(user);
        source.setPassword(pass);

        if ( ! url.startsWith("jdbc:postgresql:"))
        {
            throw new ServiceException
                ("url '"+url+"' should begin with 'jdbc:postgresql:'");
        }

        url = url.substring(16);

        if ( ! url.startsWith("//"))
        {
            //
            // database directly expressed

            if (log.isDebugEnabled())
                log.debug("setUpDataSource() DatabaseName >"+url+"<");

            source.setDatabaseName(url);
            return;
        }

        url = url.substring(2); // skip '//'

        String[] ss = url.split("/");

        String hostAndPort = ss[0];
        String databaseName = ss[1];

        if (log.isDebugEnabled())
            log.debug("setUpDataSource() DatabaseName >"+databaseName+"<");

        source.setDatabaseName(databaseName);

        if (hostAndPort.indexOf(":") > -1)
        {
            ss = hostAndPort.split(":");

            if (log.isDebugEnabled())
                log.debug("setUpDataSource() ServerName >"+ss[0]+"<");

            source.setServerName(ss[0]);

            int port = -1;
            try
            {
                port = Integer.parseInt(ss[1]);
            }
            catch (NumberFormatException nfe)
            {
                throw new ServiceException
                    ("invalid port number '"+ss[1]+"'", nfe);
            }

            if (log.isDebugEnabled())
                log.debug("setUpDataSource() PortNumber >"+port+"<");

            source.setPortNumber(port);
        }
        else
        {
            if (log.isDebugEnabled())
                log.debug("setUpDataSource() ServerName >"+hostAndPort+"<");

            source.setServerName(hostAndPort);
        }
    }

    //
    // METHODS from OwfeDataSource

    /**
     * This method when implemented has to return a piece of SQL code
     * that will be run against any database for connection
     * validity checking.
     */
    public String getConnectionValiditySqlCode ()
    {
        return CON_VALIDITY_SQL_CODE;
    }

    //
    // METHODS from Service

}
