/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;

public abstract class MapUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$MapUtils == null ? (class$openwfe$org$MapUtils = MapUtils.class$("openwfe.org.MapUtils")) : class$openwfe$org$MapUtils).getName());
    static /* synthetic */ Class class$openwfe$org$MapUtils;

    private MapUtils() {
    }

    public static String getAsString(Map map, String string) {
        Object v = map.get(string);
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public static String getAsString(Map map, String string, String string2) {
        String string3 = MapUtils.getAsString(map, string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static String getMandatoryString(Map map, String string) {
        String string2 = MapUtils.getAsString(map, string);
        if (string2 == null) {
            throw new IllegalArgumentException("mandatory parameter '" + string + "' is missing.");
        }
        return string2;
    }

    public static int getMandatoryInt(Map map, String string) {
        String string2 = MapUtils.getAsString(map, string);
        if (string2 == null) {
            throw new IllegalArgumentException("mandatory int parameter '" + string + "' is missing.");
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("mandatory int parameter '" + string + "' has value '" + string2 + "' which cannot be mapped to an integer");
        }
    }

    public static Object[] getMandatoryTimeAndString(Map map, String string) {
        String string2 = MapUtils.getMandatoryString(map, string);
        try {
            long l = Time.parseTimeString(string2);
            return new Object[]{new Long(l), string2};
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Failed to turn '" + string2 + "' into a count of milliseconds.");
        }
    }

    public static long getAsTime(Map map, String string) throws NumberFormatException {
        String string2 = MapUtils.getAsString(map, string);
        if (string2 == null) {
            throw new NumberFormatException("No assigned value for '" + string + "'");
        }
        return Time.parseTimeString(string2);
    }

    public static long getAsTime(Map map, String string, long l) throws NumberFormatException {
        String string2 = MapUtils.getAsString(map, string);
        if (string2 == null) {
            return l;
        }
        return Time.parseTimeString(string2);
    }

    public static long getAsTime(Map map, String string, String string2) throws NumberFormatException {
        String string3 = MapUtils.getAsString(map, string);
        if (string3 == null) {
            return Time.parseTimeString(string2);
        }
        return Time.parseTimeString(string3);
    }

    public static long getAsLong(Map map, String string) throws NumberFormatException {
        String string2 = MapUtils.getAsString(map, string);
        if (string2 == null) {
            throw new NumberFormatException("No assigned value for '" + string + "'");
        }
        return Long.parseLong(string2);
    }

    public static long getAsLong(Map map, String string, long l) {
        String string2 = MapUtils.getAsString(map, string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            log.info((Object)("'" + string2 + "' isn't a long value. Returning default " + l));
            return l;
        }
    }

    public static int getAsInt(Map map, String string, int n) {
        String string2 = MapUtils.getAsString(map, string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            log.info((Object)("'" + string2 + "' isn't an int value. Returning default " + n));
            return n;
        }
    }

    public static boolean getAsBoolean(Map map, String string, boolean bl) {
        Object v = map.get(string);
        if (v == null) {
            return bl;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        String string2 = v.toString();
        return string2.equalsIgnoreCase("true");
    }

    public static double getAsDouble(Map map, String string) throws NumberFormatException {
        String string2 = MapUtils.getAsString(map, string);
        if (string2 == null) {
            throw new NumberFormatException("No assigned value for '" + string + "'");
        }
        return Double.parseDouble(string2);
    }

    public static float getAsFloat(Map map, String string, float f) {
        try {
            return Float.parseFloat(MapUtils.getAsString(map, string));
        }
        catch (Throwable throwable) {
            return f;
        }
    }

    public static List getAsList(Map map, String string) {
        String string2 = (String)map.get(string);
        if (string2 == null) {
            return null;
        }
        string2 = string2.trim();
        String[] stringArray = string2.split(",\\s*");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i].trim());
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

