/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.app;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.Parameters;
import openwfe.org.ReflectionUtils;
import openwfe.org.Service;
import openwfe.org.Utils;
import openwfe.org.app.ApplicationBuildingException;
import openwfe.org.app.ApplicationContextBuilder;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class XmlApplicationContextBuilder
implements ApplicationContextBuilder {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$app$XmlApplicationContextBuilder == null ? (class$openwfe$org$app$XmlApplicationContextBuilder = XmlApplicationContextBuilder.class$("openwfe.org.app.XmlApplicationContextBuilder")) : class$openwfe$org$app$XmlApplicationContextBuilder).getName());
    static /* synthetic */ Class class$openwfe$org$app$XmlApplicationContextBuilder;

    public ApplicationContext build(Object object) throws ApplicationBuildingException {
        return this.build(object, null);
    }

    public ApplicationContext build(Object object, String string) throws ApplicationBuildingException {
        if (object == null) {
            throw new ApplicationBuildingException("Cannot build ApplicationContext out of 'null' info.");
        }
        ApplicationContext applicationContext = null;
        if (object instanceof String) {
            String string2 = (String)object;
            try {
                return this.build(new URL(Utils.expandUrl(string2)), string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ApplicationBuildingException("Cannot build ApplicationContext out of URL '" + object + "'");
            }
        }
        if (object instanceof URL) {
            return this.doBuild((URL)object, string);
        }
        if (applicationContext == null) {
            throw new ApplicationBuildingException("Cannot build ApplicationContext out of instance of class " + object.getClass());
        }
        return applicationContext;
    }

    private ApplicationContext doBuild(URL uRL, String string) throws ApplicationBuildingException {
        log.info((Object)("doBuild(u) building from '" + uRL + "'"));
        Document document = null;
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            document = sAXBuilder.build(uRL);
        }
        catch (Throwable throwable) {
            throw new ApplicationBuildingException("Failed to interpret configuration file '" + uRL + "'", throwable);
        }
        long l = -1L;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            l = uRLConnection.getLastModified();
        }
        catch (Throwable throwable) {
            log.info((Object)("doBuild() couldn't determine lastModified time for configuration file at " + uRL));
        }
        return this.doBuild(l, document.getRootElement(), string);
    }

    private ApplicationContext doBuild(long l, Element element, String string) throws ApplicationBuildingException {
        ApplicationContext applicationContext;
        Object object;
        Map map;
        ApplicationContext applicationContext2 = new ApplicationContext();
        applicationContext2.setLastModified(l);
        String string2 = element.getAttributeValue("name");
        if (string2 != null) {
            string2 = string2.trim();
            applicationContext2.setApplicationName(string2);
            ApplicationContext.contextMap.put(string2, applicationContext2);
            log.info((Object)("doBuild() put '" + string2 + "' in contextMap"));
        }
        Iterator iterator = element.getChildren("include").iterator();
        while (iterator.hasNext()) {
            map = (Element)iterator.next();
            object = map.getAttributeValue("configuration");
            applicationContext = this.build(object);
            applicationContext.setParentContext(applicationContext2);
            applicationContext2.put(applicationContext.getApplicationName(), applicationContext);
            log.info((Object)("Added sub-application under '" + applicationContext.getApplicationName() + "'"));
        }
        map = Parameters.extractParameters(element);
        applicationContext2.putAll(map);
        if (string != null) {
            applicationContext2.setApplicationDirectory(string);
        }
        this.bindSystemProperties(element);
        object = element.getChildren("service");
        iterator = object.iterator();
        while (iterator.hasNext()) {
            applicationContext = (Element)iterator.next();
            String string3 = applicationContext.getAttributeValue("name");
            String string4 = applicationContext.getAttributeValue("class");
            Map map2 = Parameters.extractParameters((Element)applicationContext);
            Service service = null;
            try {
                Class<?> clazz = Class.forName(string4);
                service = (Service)clazz.newInstance();
                service.init(string3, applicationContext2, map2);
            }
            catch (Throwable throwable) {
                log.info((Object)("Failed to instantiate service '" + string3 + "'"), throwable);
                continue;
            }
            applicationContext2.put(string3, service);
            log.info((Object)("bound service '" + string3 + "' (" + string4 + ")"));
        }
        log.info((Object)("Application '" + string2 + "' has been launched\n\n"));
        return applicationContext2;
    }

    protected void bindSystemProperties(Element element) {
        Iterator iterator = element.getChildren("property").iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            this.bindSystemProperty(element2);
        }
    }

    protected void bindSystemProperty(Element element) {
        String string = element.getAttributeValue("name");
        String string2 = element.getAttributeValue("value");
        String string3 = element.getAttributeValue("constant");
        if (string == null) {
            string = element.getChildTextTrim("name");
            string2 = element.getChildTextTrim("value");
            string3 = element.getChildTextTrim("constant");
        }
        if (string == null) {
            string = element.getChildTextTrim("property-name");
            string2 = element.getChildTextTrim("property-value");
            string3 = element.getChildTextTrim("property-constant");
        }
        if (string == null) {
            log.warn((Object)"bindSystemProperty() <property/> without a 'name' attribute. Skipped.");
            return;
        }
        if (string3 != null) {
            string2 = ReflectionUtils.lookupConstantValue(string3);
        }
        string = string.trim();
        string2 = string2.trim();
        System.getProperties().put(string, string2);
        log.info((Object)("bindSystemProperty() '" + string + "' --> '" + string2 + "'"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

