/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth;

import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import openwfe.org.auth.AuthException;
import openwfe.org.auth.Principal;
import org.apache.log4j.Logger;

public class BasicPrincipal
implements Principal {
    static final long serialVersionUID = -3421084984894408642L;
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$BasicPrincipal == null ? (class$openwfe$org$auth$BasicPrincipal = BasicPrincipal.class$("openwfe.org.auth.BasicPrincipal")) : class$openwfe$org$auth$BasicPrincipal).getName());
    public static final String NAME = "name";
    public static final String CLASS = "class";
    public static final String PASSWORD = "password";
    public static final String GRANTS = "grants";
    private String name = null;
    private Set grants = new HashSet(0);
    private String hashedPassword = null;
    private Map initParameters = null;
    static /* synthetic */ Class class$openwfe$org$auth$BasicPrincipal;

    public void init(Map map) throws AuthException {
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.put(CLASS, this.getClass().getName());
        this.initParameters = Collections.unmodifiableMap(hashMap);
        try {
            this.name = (String)map.get(NAME);
            this.hashedPassword = (String)map.get(PASSWORD);
            Object v = map.get(GRANTS);
            if (v != null) {
                this.grants = (Set)v;
            }
        }
        catch (ClassCastException classCastException) {
            throw new AuthException("init failed", classCastException);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() initted '" + this.name + "'"));
        }
        if (this.name == null) {
            throw new AuthException("Parameter 'name' is missing for Principal building");
        }
        if (this.grants == null) {
            this.grants = new HashSet();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        BasicPrincipal basicPrincipal = null;
        try {
            basicPrincipal = (BasicPrincipal)object;
        }
        catch (Exception exception) {
            return false;
        }
        if (!this.name.equals(basicPrincipal.name)) {
            return false;
        }
        if (this.grants.size() != basicPrincipal.grants.size()) {
            return false;
        }
        Iterator iterator = this.grants.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (basicPrincipal.grants.contains(string)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("\n");
        stringBuffer.append("  name=\"");
        stringBuffer.append(this.name);
        stringBuffer.append("\" \n");
        stringBuffer.append("> \n");
        Iterator iterator = this.grants.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("  <grant name=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" /> \n");
        }
        stringBuffer.append("</");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setHashedPassword(String string) {
        this.hashedPassword = string;
    }

    public boolean isCopy() {
        return this.hashedPassword == null;
    }

    public boolean authentify(Object object) throws AuthException {
        if (this.hashedPassword == null) {
            throw new AuthException("Cannot authentify Principal against a principal copy");
        }
        return this.hashedPassword.equals(object);
    }

    public Set getGrants() {
        return this.grants;
    }

    public Principal getWorkCopy() {
        BasicPrincipal basicPrincipal = new BasicPrincipal();
        this.fill(basicPrincipal);
        basicPrincipal.hashedPassword = null;
        return basicPrincipal;
    }

    public void addGrant(String string) {
        if (!this.grants.contains(string)) {
            this.grants.add(string);
        }
    }

    public void removeGrant(String string) {
        this.grants.remove(string);
    }

    public Map getInitParameters() {
        return this.initParameters;
    }

    public void fill(BasicPrincipal basicPrincipal) {
        basicPrincipal.name = this.name;
        basicPrincipal.hashedPassword = this.hashedPassword;
        basicPrincipal.grants = this.grants;
    }

    public String getHashedPassword() {
        return this.hashedPassword;
    }

    public static BasicPrincipal getBasicPrincipal(Subject subject) {
        Set set = subject.getPrincipals(class$openwfe$org$auth$BasicPrincipal == null ? (class$openwfe$org$auth$BasicPrincipal = BasicPrincipal.class$("openwfe.org.auth.BasicPrincipal")) : class$openwfe$org$auth$BasicPrincipal);
        Iterator iterator = set.iterator();
        BasicPrincipal basicPrincipal = (BasicPrincipal)iterator.next();
        return basicPrincipal;
    }

    public static BasicPrincipal getBasicPrincipal() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        return BasicPrincipal.getBasicPrincipal(subject);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

