/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth.xml;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.Parameters;
import openwfe.org.ReflectionUtils;
import openwfe.org.Utils;
import openwfe.org.auth.AuthException;
import openwfe.org.auth.Grant;
import openwfe.org.auth.Passwd;
import openwfe.org.auth.PasswdCodec;
import openwfe.org.auth.Permission;
import openwfe.org.auth.Principal;
import openwfe.org.auth.xml.XmlPrincipalCodec;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class XmlPasswdCodec
implements PasswdCodec {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$xml$XmlPasswdCodec == null ? (class$openwfe$org$auth$xml$XmlPasswdCodec = XmlPasswdCodec.class$("openwfe.org.auth.xml.XmlPasswdCodec")) : class$openwfe$org$auth$xml$XmlPasswdCodec).getName());
    public static final String NAME = "name";
    public static final String CLASS = "class";
    public static final String GRANT = "grant";
    public static final String PASSWD = "passwd";
    public static final String CODEBASE = "codebase";
    public static final String PRINCIPAL = "principal";
    public static final String PERMISSION = "permission";
    private static final XmlPermissionCodec permissionCodec = new XmlPermissionCodec();
    private static final XmlPrincipalCodec principalCodec = new XmlPrincipalCodec();
    private Element rootElement = null;
    private URL docUrl = null;
    private ApplicationContext context = null;
    private Map serviceParams = null;
    private Passwd decodedPasswd = null;
    private long lastModified = 0L;
    static /* synthetic */ Class class$openwfe$org$auth$xml$XmlPasswdCodec;

    public void init(ApplicationContext applicationContext, Map map) {
        this.context = applicationContext;
        this.serviceParams = map;
    }

    private Object doEncodePasswd(Passwd passwd) throws AuthException {
        Element element = new Element(PASSWD);
        element.setAttribute(NAME, passwd.getName());
        Iterator iterator = passwd.getPrincipalMap().values().iterator();
        while (iterator.hasNext()) {
            element.addContent((Content)((Element)principalCodec.encodePrincipal((Principal)iterator.next(), null, null)));
        }
        iterator = passwd.getGrantMap().values().iterator();
        while (iterator.hasNext()) {
            element.addContent((Content)this.encodeGrant((Grant)iterator.next()));
        }
        return element;
    }

    public void encodePasswd(Passwd passwd) throws AuthException {
        Element element = (Element)this.doEncodePasswd(passwd);
        try {
            String string = this.docUrl.toString();
            if (string.startsWith("file:")) {
                string = string.substring(5);
            }
            FileWriter fileWriter = new FileWriter(string);
            XMLOutputter xMLOutputter = XmlUtils.getXMLOutputter();
            xMLOutputter.output(new Document(element), (Writer)fileWriter);
        }
        catch (IOException iOException) {
            throw new AuthException("Failed to output passwd back to " + this.docUrl, iOException);
        }
    }

    public Passwd decodePasswd() throws AuthException {
        return this.decodePasswd(null);
    }

    public Passwd decodePasswd(Object object) throws AuthException {
        this.docUrl = null;
        try {
            String string;
            if (object != null) {
                if (object instanceof String) {
                    string = (String)object;
                    string = Utils.expandUrl(this.context.getApplicationDirectory(), string);
                    this.docUrl = new URL(string);
                } else if (object instanceof URL) {
                    this.docUrl = (URL)object;
                }
            } else if (this.serviceParams != null) {
                string = (String)this.serviceParams.get(PASSWD);
                string = Utils.expandUrl(this.context.getApplicationDirectory(), string);
                this.docUrl = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new AuthException("Cannot extract xml out of object of class '" + object.getClass().getName() + "'", malformedURLException);
        }
        if (this.docUrl == null) {
            throw new AuthException("Cannot turn your instance of '" + object.getClass().getName() + "' into a Passwd instance.");
        }
        long l = -1L;
        try {
            URLConnection uRLConnection = this.docUrl.openConnection();
            l = uRLConnection.getLastModified();
        }
        catch (IOException iOException) {
            log.warn((Object)("decodePasswd() failed to connect to " + this.docUrl));
        }
        log.debug((Object)("decodePasswd() modified       : " + l));
        log.debug((Object)("decodePasswd() lastModified   : " + this.lastModified));
        if (this.lastModified < 1L || this.lastModified < l) {
            log.debug((Object)"decodePasswd() reloading...");
            try {
                this.rootElement = XmlUtils.extractXml(this.docUrl, false);
            }
            catch (Exception exception) {
                throw new AuthException("Failed to decode XML document '" + this.docUrl + "'", exception);
            }
            this.decodedPasswd = this.decode(this.rootElement);
            this.lastModified = l;
        }
        return this.decodedPasswd;
    }

    protected Map extractAttributes(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            hashMap.put(attribute.getName(), attribute.getValue());
        }
        return hashMap;
    }

    protected Grant extractGrant(Element element) throws AuthException {
        String string = element.getAttributeValue(NAME);
        String string2 = element.getAttributeValue(CODEBASE);
        HashSet<Permission> hashSet = new HashSet<Permission>();
        Iterator iterator = element.getChildren(PERMISSION).iterator();
        while (iterator.hasNext()) {
            Permission permission = permissionCodec.decodePermission((Element)iterator.next());
            hashSet.add(permission);
        }
        try {
            return new Grant(string, string2, hashSet);
        }
        catch (Exception exception) {
            throw new AuthException("Failed to extract Grant", exception);
        }
    }

    protected Passwd decode(Element element) throws AuthException {
        Serializable serializable;
        if (!element.getName().equals(PASSWD)) {
            throw new AuthException("Waiting for xml element named 'passwd' not '" + element.getName() + "'.");
        }
        String string = element.getAttributeValue(NAME);
        if (string == null) {
            string = PASSWD;
        }
        string = string.trim();
        log.info((Object)("decode() Passwd name is '" + string + "'"));
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>(40);
        Iterator iterator = element.getChildren(PRINCIPAL).iterator();
        while (iterator.hasNext()) {
            serializable = principalCodec.decodePrincipal(null, iterator.next());
            arrayList.add(serializable);
        }
        serializable = new HashMap();
        iterator = element.getChildren(GRANT).iterator();
        while (iterator.hasNext()) {
            Grant grant = null;
            try {
                grant = this.extractGrant((Element)iterator.next());
            }
            catch (AuthException authException) {
                log.warn((Object)"decode() failed to decode a Grant. Skipped it.", (Throwable)authException);
                continue;
            }
            serializable.put(grant.getName(), grant);
        }
        return new Passwd(string, arrayList, (Map)((Object)serializable));
    }

    protected Element encodeGrant(Grant grant) {
        Element element = new Element(GRANT);
        element.setAttribute(NAME, grant.getName());
        element.setAttribute(CODEBASE, grant.getUrl());
        Enumeration<java.security.Permission> enumeration = grant.getPermissions().elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = (Permission)enumeration.nextElement();
            try {
                Element element2 = permissionCodec.encodePermission(permission);
                element.addContent((Content)element2);
            }
            catch (AuthException authException) {
                log.warn((Object)("Failed to encode a Permission of grant '" + grant.getName() + "'"), (Throwable)authException);
            }
        }
        return element;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class XmlPermissionCodec {
        private XmlPermissionCodec() {
        }

        public Element encodePermission(Permission permission) throws AuthException {
            Element element = new Element(XmlPasswdCodec.PERMISSION);
            Map map = permission.getParameters();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                element.setAttribute(string, string2);
            }
            element.setAttribute(XmlPasswdCodec.CLASS, permission.getClass().getName());
            return element;
        }

        public Permission decodePermission(Element element) throws AuthException {
            try {
                Map map = Parameters.extractAttributes(element);
                String string = (String)map.get(XmlPasswdCodec.CLASS);
                Class<?> clazz = Class.forName(string);
                Permission permission = (Permission)ReflectionUtils.buildInstance(clazz, map);
                return permission;
            }
            catch (Exception exception) {
                throw new AuthException("Failed to decode permission", exception);
            }
        }
    }
}

