/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.Parameters;
import openwfe.org.ReflectionUtils;
import openwfe.org.auth.AuthException;
import openwfe.org.auth.Principal;
import openwfe.org.auth.PrincipalCodec;
import org.jdom.Content;
import org.jdom.Element;

public class XmlPrincipalCodec
implements PrincipalCodec {
    public static final String E_PRINCIPAL = "principal";
    public static final String A_CLASS = "class";
    public static final String A_NAME = "name";
    public static final String E_GRANT = "grant";

    public Object encodePrincipal(Principal principal, ApplicationContext applicationContext, Map map) throws AuthException {
        Element element = new Element(E_PRINCIPAL);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (principal.getInitParameters() != null) {
            hashMap.putAll(principal.getInitParameters());
        }
        hashMap.put(A_CLASS, principal.getClass().getName());
        Parameters.encodeAsAttributes(element, hashMap);
        Iterator iterator = principal.getGrants().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Element element2 = new Element(E_GRANT);
            element2.setAttribute(A_NAME, string);
            element.addContent((Content)element2);
        }
        return element;
    }

    public Principal decodePrincipal(ApplicationContext applicationContext, Object object) throws AuthException {
        Element element = null;
        try {
            element = (Element)object;
        }
        catch (ClassCastException classCastException) {
            throw new AuthException("Cannot decode Principal from class " + object.getClass(), classCastException);
        }
        if (element == null || !element.getName().equals(E_PRINCIPAL)) {
            throw new AuthException("null XML element or not a <principal>");
        }
        Principal principal = null;
        Map map = Parameters.extractAttributes(element);
        String string = (String)map.get(A_CLASS);
        try {
            principal = (Principal)ReflectionUtils.initObjectOfClass(string, map);
        }
        catch (Exception exception) {
            throw new AuthException("failed to build Principal of class " + string, exception);
        }
        Iterator iterator = element.getChildren(E_GRANT).iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            principal.addGrant(element2.getAttributeValue(A_NAME));
        }
        return principal;
    }
}

